/* -*- C++ -*-
 * This file implements the class for interfacing xhost.
 * It is part of khost.
 * khost is a GUI to xhost.
 *
 * khost is part of the K Desktop Environment
 * copyright:  (C) Mirko Sucker, 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4
 * $Revision: 1.3 $
 */

#include "khost.h" // the interface definition
#include <kprocess.h>
#include <qstring.h>
#include <kapp.h>

extern "C" {
#include <unistd.h>
  
}

// #############################################################################
// MOC OUTPUT FILES:
#include "xhostinterface.moc"
// #############################################################################

XHostInterface::XHostInterface()
{
  // ###########################################################################
  proc=new KProcess;
  connect(proc, SIGNAL(processExited(KProcess*)), SLOT(done(KProcess*)));
  connect(&timer, SIGNAL(timeout()), SLOT(timeout()));
  // ###########################################################################
}

XHostInterface::~XHostInterface()
{
  // ###########################################################################
  proc->clearArguments();
  delete proc;
  // ###########################################################################
}

/*
  bool
  XHostInterface::isXHostAvailable()
  {
  // ###########################################################################
  // ###########################################################################
  }
*/

bool
XHostInterface::enableHostAccessControl(bool state)
{
  // ###########################################################################
  char* args[]= {
    state ? "-" : "+" 
  };
  const int argc=sizeof(args)/sizeof(args[0]);
  // -----
  return callXHost(argc, args);
  // ###########################################################################
}

bool
XHostInterface::addAllowedHost(const char* host)
{ // make sure access control has been enabled before!
  // ###########################################################################
  char* args[]= { "+" , (char*)host };
  const int argc=sizeof(args)/sizeof(args[0]);
  // -----
  return callXHost(argc, args);
  // ###########################################################################
}

bool
XHostInterface::removeHostname(const char* host)
{ // make sure access control has been enabled before!
  // ###########################################################################
  char* args[]= { "-" , (char*)host };
  const int argc=sizeof(args)/sizeof(args[0]);
  // -----
  return callXHost(argc, args);
  // ###########################################################################
}

bool
XHostInterface::callXHost(int argc, char** argv)
{
  // ###########################################################################
  int count;
  bool rc;
  int time=0;
  // -----
  if(proc->isRunning())
    {
      emit(setStatus(i18n("Error: khost is doing a call already.")));
      return false;
    }
  // ----- set command to call:
  proc->clearArguments();
  (*proc) << "xhost";
  for(count=0; count<argc; ++count)
    {
      (*proc) << argv[count];
    }
  // ----- set hourglass cursor and call xhost:
  QApplication::setOverrideCursor(waitCursor); // reset in done();
  rc=proc->start();
  for(time=0; time<50; ++time)
    {
      if(proc->isRunning())
	{
	  sleep(100);
	} else {
	  kapp->processEvents(); // for possibly receiving signals
	  break;
	}
      kapp->processEvents();
    }
  if(time>15)
    {
      emit(setStatus(i18n("Warning: xhost call took a long time.")));
    }
  // -----
  return rc;
  // ###########################################################################
}

void
XHostInterface::done(KProcess *proc)
{
  // ###########################################################################
  QApplication::restoreOverrideCursor();
  QString text;
  int es;
  // -----
  if(proc->normalExit())
    {
      es=proc->exitStatus();
      switch(es)
	{
	case 0:
	  emit(setStatus(i18n("xhost call: No errors.")));
	  break;
	default:
	  text.sprintf(i18n("xhost call: job exited with code %i."), es);
	  emit(setStatus(text));
	}
    } else {
      emit(setStatus(i18n("Error: xhost has been killed by a signal.")));
    }
  // ###########################################################################
}

void
XHostInterface::timeout()
{
  // ###########################################################################
  // what to do?
  // ###########################################################################
}

  



