/*
	searchdlg.h - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#include <qdialog.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qlistbox.h>
#include <qcombobox.h>
#include <krestrictedline.h>
#include "catsearch.h"
#include "keditmask.h"

class SearchDlg : public QDialog
{
   Q_OBJECT
public:
   SearchDlg(QWidget* parent = NULL,const char* name = NULL,QStrList* categories = 0,QString current = "");
   virtual ~SearchDlg();
   void getCriteria(CatCriteria* crit);
protected slots:
   void slotOk();
   void slotCbxTextSearch();
   void slotCbxSizeFrom();
	void slotCbxSizeTo();
	void slotCbxDateFrom();
	void slotCbxDateTo();
   void slotSelectAll();
   void slotSelectNone();
   void slotSelectCurrent();
protected:
	void init();
	void initQuickHelp();
	void saveSettings();
	void loadSettings();
   QStrList getSelectedCategories();
   bool checkFilter();
	
	QString current_category;

	QFrame* fr_reg_expr;
	QButtonGroup* bg_search_mode;
	QRadioButton* rb_regexp;
	QPushButton* pb_search;
	QPushButton* pb_cancel;
	QCheckBox* cbx_match_filename;
	QCheckBox* cbx_match_descriptions;
	QLabel* lb_reg_expr;
	QComboBox* sle_reg_expr;
	QCheckBox* cbx_text_search;
	QFrame* fr_size;
	QLabel* lb_size_condition;
	QCheckBox* cbx_size_from;
	KRestrictedLine* sle_size_from;
	QCheckBox* cbx_size_to;
	KRestrictedLine* sle_size_to;
	QFrame* fr_date_search;
	QLabel* lb_date_condition;
	KEditMask* ke_date_from;
	KEditMask* ke_date_to;
	QCheckBox* cbx_date_from;
	QCheckBox* cbx_date_to;
	QRadioButton* rb_wildcard;
	QCheckBox* cbx_case_sens;
	QListBox* lbox_categories;
	QPushButton* pb_select_all;
	QPushButton* pb_select_none;
	QPushButton* pb_select_current;

	KEditMaskDefinitionDateTime* ked_from;
	KEditMaskDefinitionDateTime* ked_to;
};

#endif