/*
	pluginconfig.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <iostream.h>

#include <kapp.h>
#include <kmsgbox.h>
#include <qdir.h>
#include "pluginconfig.h"
#include "pluginconfigedit.h"
#include "postprocess.h"
#include "util.h"

extern const char list_separator;

PluginConfig::PluginConfig(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
   lv_list->setSeparator(list_separator);

   connect(pb_ok,SIGNAL(clicked()),this,SLOT(slotOk()));
   connect(pb_cancel,SIGNAL(clicked()),this,SLOT(reject()));
   connect(pb_add,SIGNAL(clicked()),this,SLOT(slotAdd()));
   connect(pb_edit,SIGNAL(clicked()),this,SLOT(slotEdit()));
   connect(pb_delete,SIGNAL(clicked()),this,SLOT(slotDelete()));
   connect(pb_auto,SIGNAL(clicked()),this,SLOT(slotAuto()));

   readConfig();
}

PluginConfig::~PluginConfig(){
}

void PluginConfig::slotOk()
{
	writeConfig();
   accept();
}

void PluginConfig::slotAdd()
{
	PluginConfigEdit dia(this,"dia");
	QString str;
	int index=0;
	
	if (dia.exec())
	{
		if (dia.cbx_on->isChecked())
		{
			str="ON";
		}
		else
		{
			str="OFF";
		}
		str+=list_separator;
		str+=dia.sle_command->text();
		str+=list_separator;
		str+=dia.sle_associated->text();
		str+=list_separator;
		str+=dia.sle_fire->text();
		lv_list->appendItem(str);
		index=lv_list->count() - 1;
		lv_list->setCurrentItem(index);
	}
}

void PluginConfig::slotEdit()
{
	PluginConfigEdit dia(this,"dia");
	QString str;
	int index;
	
	index=lv_list->currentItem();
	if (index != -1)
	{
   	if (lv_list->isMarked(index))
   	{
       	str=lv_list->text(index);
     		dia.cbx_on->setChecked(Util::cropFirstWord(&str,list_separator)=="ON");
        	dia.sle_command->setText(Util::cropFirstWord(&str,list_separator));
     		dia.sle_associated->setText(Util::cropFirstWord(&str,list_separator));
        	dia.sle_fire->setText(Util::cropFirstWord(&str,list_separator));
      	if (dia.exec())
      	{
      		if (dia.cbx_on->isChecked())
      		{
      			str="ON";
      		}
      		else
      		{
      			str="OFF";
      		}
      		lv_list->changeItemPart(str,index,0);
      		lv_list->changeItemPart(dia.sle_command->text(),index,1);
      		lv_list->changeItemPart(dia.sle_associated->text(),index,2);
      		lv_list->changeItemPart(dia.sle_fire->text(),index,3);
      	}
      }
	}
}

void PluginConfig::slotDelete()
{
	int index;
	
	index=lv_list->currentItem();
	if (index != -1)
	{
   	if (lv_list->isMarked(index))
   	{
   	   if (KMsgBox::yesNo(this,i18n("Message"),i18n("Are you sure?"))==1)
     		{
   			lv_list->removeItem(index);
   			lv_list->setCurrentItem(-1);
   		}
   	}
 	}
}

void PluginConfig::slotAuto()
{
	lv_list->clear();
	autoConfig(0);
	readConfig();
}

void PluginConfig::readConfig()
{
	KConfig* config;
	uint i,to;
	QString tmp,str;

   config=kapp->getConfig();

   config->setGroup("ADE PLUGINS");
   to=config->readNumEntry("NumberOfPlugins",0);
   for (i=0;i<to;i++)
   {
   	str.setNum(i);
      tmp=config->readEntry("Plugin"+str);
      lv_list->appendItem(tmp);

      // Required because of a KTabListBox bug
      lv_list->changeItemPart(Util::cropFirstWord(&tmp,list_separator),lv_list->count() - 1,0);
      lv_list->changeItemPart(Util::cropFirstWord(&tmp,list_separator),lv_list->count() - 1,1);
      lv_list->changeItemPart(Util::cropFirstWord(&tmp,list_separator),lv_list->count() - 1,2);
      lv_list->changeItemPart(Util::cropFirstWord(&tmp,list_separator),lv_list->count() - 1,3);
   }
}

void PluginConfig::writeConfig()
{
	KConfig* config;
	uint i;
	QString str;
	
   config=kapp->getConfig();

   config->setGroup("ADE PLUGINS");
   config->writeEntry("NumberOfPlugins",lv_list->count());
   for (i=0;i<lv_list->count();i++)
   {
   	str.setNum(i);
      config->writeEntry("Plugin"+str,lv_list->text(i));
   }
}

void PluginConfig::autoConfig(SetupUpdateDlg* dia)
{
	QDir dir(kapp->kde_datadir()+"/kdiskcat/plugins",0,QDir::Name);
	if (dir.exists())
	{
      const QFileInfoList *files= dir.entryInfoList();
      QFileInfoListIterator files_it(*files);
      QFileInfo *f;
   	KConfig* config;
   	uint i=0;
   	QString str,ret;
   	QString info;

      config=kapp->getConfig();
      config->setGroup("ADE PLUGINS");
      while ((f=files_it.current()) != 0)
      {
         ++files_it;
         if ((!f->isDir()) && (f->isExecutable()))
         {
          	PluginClient* client=new PluginClient(f->absFilePath());
            ret=client->defaults();
            delete client;
            if (ret != "")
            {
            	info="   ";
            	info+=i18n("Plugin found:");
            	info+=" ";
            	info+=f->fileName();
            	if (dia)
            	{
	   				dia->message(info);
					}
					
            	i++;

   			   config->writeEntry("NumberOfPlugins",i);
   		   	str.setNum(i - 1);
   		      config->writeEntry("Plugin"+str,"ON|"+f->absFilePath()+"|"+ret);
   			}
         }
   	}
   }
}
