/*
	newcategorydlg.cpp - part of KDiskCat the KDE Disk Catalog.

	Copyright (c) 1998,1999 Balzs Ternyi <terenyi@freemail.c3.hu>

	KDiskCat is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
			
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
					
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <kapp.h>
#include <kmsgbox.h>
#include "newcategorydlg.h"

NewCategoryDlg::NewCategoryDlg(QWidget *parent, const char *name ) : QDialog(parent,name,true)
{
   int width1, width2, width3;
   setCaption(i18n("New category"));

   lb_name=new QLabel(i18n("Category name:"),this,"lb_name");
   width3 = lb_name->fontMetrics().width(lb_name->text())+20;
   lb_name->setGeometry(10, 10, width3, 24);

   sle_name=new QLineEdit(this,"sle_name");
   sle_name->setGeometry(width3, 10, 140, 24);
   sle_name->setFocus();

   setMinimumSize(width3+160, 85);

   pb_ok=new QPushButton(i18n("Ok"),this,"pb_ok");
   width1 = pb_ok->fontMetrics().width(pb_ok->text());
   pb_ok->setDefault( TRUE );
	
   pb_cancel=new QPushButton(i18n("Cancel"),this,"pb_cancel");
   width2 = pb_cancel->fontMetrics().width(pb_cancel->text());

   if (width1 < width2) width3 = width2; else width3 = width1;
   width3 += 20;
   if (60+2*width3 > minimumSize().width())
     setMinimumSize(60+2*width3, minimumSize().height());
   setMaximumSize(minimumSize());

   pb_ok    ->setGeometry(width()/2-20-width3, 44, width3, 30);
   pb_cancel->setGeometry(width()/2+20,        44, width3, 30);

   connect(pb_ok,SIGNAL(clicked()),this,SLOT(slotOk()));
   connect(pb_cancel,SIGNAL(clicked()),this,SLOT(reject()));
}

NewCategoryDlg::~NewCategoryDlg()
{
   delete lb_name;
   delete sle_name;
}

void NewCategoryDlg::slotOk()
{
	QString str=sle_name->text();
	if ((str.find('/') > -1) || (str.find('|') > -1))
	{
		KMsgBox::message(this,i18n("Message"),i18n("Invalid character in the name!"),KMsgBox::STOP);
	}
	else
	{
		if (str != "")
		{
		   accept();
		}
	}
}
