/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include <qdir.h>
#include <qlabel.h>
#include <klocale.h>
#include <kmsgbox.h>

#include "kthememan.h"
#include "dialogs.h"

KThemeMan::~KThemeMan(){
}

KThemeMan::KThemeMan(QWidget * parent, const char *name, Theme *t):QWidget (parent, name){
	theme=t;
	themepath=kapp->kde_datadir()+"/ktheme";
	
	theme_box=new QListBox(this);
	old_item=-1;

	QDir d(themepath);
	d.setFilter( QDir::Files );
	d.setSorting( QDir::Name );
	d.setNameFilter("*.ktheme");

	theme_box->clear();
	for ( unsigned int i=0; i<d.count(); i++ ) {
		QString tmp=d[i];
		theme_box->insertItem(tmp.left(tmp.find(".")));
	}
	theme_box->setAutoUpdate(TRUE);
	
	saveTheme=new QPushButton(this);
	saveTheme->resize(100,30);
	saveTheme->setText(klocale->translate("Save changes"));

	createNew=new QPushButton(this);
	createNew->resize(100,30);
	createNew->setText(klocale->translate("Add new"));

	removeTheme=new QPushButton(this);
	removeTheme->resize(100,30);
	removeTheme->setText(klocale->translate("Remove"));

	connect(removeTheme,SIGNAL(clicked()),SLOT(slot_removeTheme()));
	connect(createNew,SIGNAL(clicked()),SLOT(slot_addTheme()));
	connect(saveTheme,SIGNAL(clicked()),SLOT(slot_saveChanges()));

	connect(theme_box, SIGNAL(highlighted(int)),SLOT(slot_changeListItem(int)));

	loadConf();
}

void KThemeMan::resizeEvent(QResizeEvent *){
	theme_box->setGeometry(20,20,width()-160,110);
	saveTheme->move(width()-130,20);
	createNew->move(width()-130,60);
	removeTheme->move(width()-130,100);
}

void KThemeMan::slot_addTheme(){
	GetNameWindow *gnw=new GetNameWindow();
	if (gnw->openWindow("Enter Name")){
		QString 	name=gnw->getInput();
		bool		ex=true;
		for (unsigned int i=0;i<theme_box->count();i++){
			if (QString(theme_box->text(i))==name) ex=false;
		}
		if (ex){
			theme->save(themepath+"/"+name+".ktheme");
			theme_box->insertItem(name);
			theme_box->setCurrentItem(theme_box->count()-1);
		}else{
			KMsgBox *er=new KMsgBox(this,klocale->translate("Error"),klocale->translate("Themename already used."),KMsgBox::EXCLAMATION,"Ok");
			er->show();
		}
	}
}

void KThemeMan::slot_removeTheme(){
	KMsgBox *q=new KMsgBox ();
	if (q->yesNo(this,klocale->translate("Question"),klocale->translate("Are you sure?"),KMsgBox::EXCLAMATION)==1){
			QDir d(themepath);
			d.remove(themepath+"/"+theme_box->text(theme_box->currentItem())+".ktheme");
			theme_box->removeItem(theme_box->currentItem());
			debug("Theme deleted!");
	}
}

void KThemeMan::slot_saveChanges(){
	theme->save(themepath+"/"+theme_box->text(theme_box->currentItem())+".ktheme");
}

void KThemeMan::slot_changeListItem(int item){
	if (item!=old_item){
		if (theme->changed){
			KMsgBox *q=new KMsgBox ();
			if (q->yesNo(this,klocale->translate("Error"),klocale->translate("Changings not saved. Continue?"),KMsgBox::EXCLAMATION)==1){
				old_item=item;
				theme->load(themepath+"/"+theme_box->text(theme_box->currentItem())+".ktheme");
			}else{
				theme_box->setCurrentItem(old_item);
			}
		}else{
			old_item=item;
			theme->load(themepath+"/"+theme_box->text(theme_box->currentItem())+".ktheme");
		}
	}
}

void KThemeMan::loadConf(){
	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();

	config->setGroup("General");
	int st=config->readNumEntry("selectedTheme",0);
	theme_box->setCurrentItem(st);
}

void KThemeMan::saveConf(){
	KConfigBase *config;
	config=	KApplication::getKApplication()->getConfig();

	config->setGroup("General");
	config->writeEntry("selectedTheme", theme_box->currentItem());
	config->sync();
}

