/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#ifndef KTHEMEGFXCONFIG_H
#define KTHEMEGFXCONFIG_H

#include <kapp.h>
#include <kcontrol.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qgrpbox.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qpushbt.h>

#include "theme.h"

class KThemeGfxConfig : public KConfigWidget{
	Q_OBJECT
public:
	KThemeGfxConfig(QWidget *parent=0, const char *name=0, Theme *t=NULL);
	~KThemeGfxConfig();
	void resizeEvent(QResizeEvent *);
	void writeSettings();
	void loadSettings();

public slots:
	void applySettings();
	void loadImage(int index);
	void setDesktop();
	void buttonSelect();
	void slot_getCS();
	void themeChanged();

private:
	QListBox 	*gfx_listbox;
	QListBox 	*desktop;
	QLabel		*preview;
	QString		path_pic;
	QGroupBox	*desktopgroup;
	QGroupBox	*wallpapergroup;
	QButtonGroup	*wallpaperbuttongroup;
	QRadioButton	*wprb1;
	QRadioButton	*wprb2;
	QRadioButton	*wprb3;
	QPushButton	*getCS;
	Theme		*theme;
	int		desktops;
	int		currentdesktop;
};

#endif


