/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#ifndef KTHEMECOLORCONFIG_H
#define KTHEMECOLORCONFIG_H

#include <kapp.h>
#include <kcontrol.h>
#include <ksimpleconfig.h>

#include <qpushbt.h>
#include <widgetcanvas.h>
#include <qlistbox.h>

#include "theme.h"

class KThemeColorConfig : public KConfigWidget{
	Q_OBJECT
public:
	KThemeColorConfig(QWidget * parent, const char *name, Theme *theme);
	~KThemeColorConfig();
	void resizeEvent(QResizeEvent *);
	void writeSettings();
	void writeSettings(QString name);
	void writeSettings(KConfigBase *config, bool ftyp);

public slots:
	void applySettings();
	void selectScheme(int index);
	void loadScheme(QString name);
	void loadSettings();
	void themeChanged();
	void slot_saveScheme();
	void slot_deleteScheme();


protected:
	QPushButton	*saveScheme;
	QPushButton	*deleteScheme;
	QListBox 	*scheme_Listbox;
	WidgetCanvas	*preview;
	QString		path_scheme;
	QString		oldscheme;
	Theme		*theme;
};

#endif


