/*************************************************************************
 *                                                                       *
 *  KTheme                                                               *
 *                                                                       *
 * This file is part of the KTheme-Package. For detail information about *
 * this program have a look at the README-File.                          *
 *                                                                       *
 * Copyright(c) 1998 Christian Poulter.                                  *
 *                                                                       *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation - version 2.                             *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License in file COPYING for more details.          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program; if not, write to the Free Software           *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             *
 *                                                                       *
 *  On the Net at http://www.wilhelmshaven-online.de/benutzer/cpoulter   *
 *  Email to cpoulter@ebs-net.com                                        *
 *                                                                       *
 *************************************************************************/

#include "kcontrol.h"
#include "ktheme.h"

KThemeApp::~KThemeApp(){
	kthememan->saveConf();
}

KThemeApp::KThemeApp(int &argc, char **argv, const char *name):KControlApplication(argc, argv, name){
	theme=new Theme();
		debug("0");
	if (runGUI()){
		kthemegfxconfig  	=new KThemeGfxConfig  	(dialog, 0, theme);
		kthemesoundconfig	=new KThemeSoundConfig	(dialog, 0, theme);
		kthemecolorconfig	=new KThemeColorConfig	(dialog, 0, theme);
		kthememan        	=new KThemeMan        	(dialog, 0, theme);
		kthemeinfo		=new KThemeInfo		(dialog, 0);

	       	addPage(kthemegfxconfig,   klocale->translate("Wallpaper"), "wallpaper.html");
       		addPage(kthemecolorconfig, klocale->translate("Colors"),    "color.html");
		addPage(kthemesoundconfig, klocale->translate("Sounds"),    "sound.html");
       		addPage(kthememan,         klocale->translate("Manager"),   "manager.html");
	    	addPage(kthemeinfo,	   klocale->translate("Info"),      "ktheme.html");
		dialog->show();
	}
}


void KThemeApp::init(){
}

void KThemeApp::apply(){
	QApplication::setOverrideCursor( waitCursor );
	kthemecolorconfig->applySettings();
	kthemesoundconfig->applySettings();
	kthemegfxconfig->applySettings();
	theme->applyTheme();
	QApplication::restoreOverrideCursor();
}

int main(int argc, char **argv){
	KThemeApp app(argc, argv, "ktheme");
	app.setTitle(klocale->translate("KTheme Manager"));
  
	if (app.runGUI()){
		return app.exec();
	}else{
		app.init();
		return 0;
  	}
}
