#ifndef FFT_H
#define FFT_H

#include <qwidget.h>

struct freqdata { int num[20]; };

/* ------------------------------------------------------------------------ */

class FFTWindow : public QWidget
{
    Q_OBJECT;

public:
    FFTWindow(QWidget *parent, char *name);

signals:
   void sendData(freqdata*);

public slots:
    void new_params(struct SOUNDPARAMS *params);
    void new_data(void *data);
    void pause();

private:
    unsigned long  fore,back;
    int            *logmap;
    short          *buffer;

    int            afmt,channels,rate;
    int            audio_size, fft_size, lmax;
    int            data, paused;
    freqdata       fdata;
    
    void make_logmap();
    void calculate(unsigned char *data);
    void drawhist();
};

#endif
