C================================================================================
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> NRF_IAR.F <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
C================================================================================
C>>>>>>>>>>>>>>>>>>>>>>>>> NUMERICAL RECIPES ROUTINES <<<<<<<<<<<<<<<<<<<<<<<<<<<
c
c       This file is part of krot,
c       a program for the simulation, assignment and fit of HRLIF spectra.
c       
c       Copyright (C) 1997,1998 Dave Plusquellic
c       Copyright (C) 1998 Jochen K"upper
c
c       $Id: nrf_iar.f,v 1.3 1998/08/14 15:37:35 jochen Exp $


	subroutine htridi(nm,n,ar,ai,d,e,e2,tau)
	implicit double precision (a-h,o-z)
	dimension ar(nm,n),ai(nm,n),d(n),e(n),e2(n),tau(2,n)
c	double complex zcmplx


	tau(1,n) = 1.0
 	tau(2,n) = 0.0
	do 100 i = 1,n
  100	d(i) = ar(i,i)
	do 300 ii = 1,n
	i = n + 1 - ii
	l = i - 1
	h = 0.0
	scale = 0.0
	if (l .lt. 1) go to 130
c Scale row
	do 120 k = 1,l
  120	scale = scale + dabs(ar(i,k)) + dabs(ai(i,k))
c
	if (scale .ne. 0.0) go to 140
	tau(1,l) = 1.0
	tau(2,l) = 0.0
  130	e(i) = 0.0
	e2(i) = 0.0
	go to 290
c
  140	do 150 k = 1,l
	ar(i,k) = ar(i,k)/scale
	ai(i,k) = ai(i,k)/scale
	h = h  +ar(i,k)*ar(i,k) + ai(i,k)*ai(i,k)
  150	continue
c
	e2(i) = scale*scale*h
	g = dsqrt(h)
 	e(i) = scale * g
	f = zabs(dcmplx(ar(i,l),ai(i,l)))
c Form next diagonal element of matrix t
	if (f .eq. 0.0) go to 160
	tau(1,l) = (ai(i,l)*tau(2,i) - ar(i,l)*tau(1,i))/f
	si = (ar(i,l)*tau(2,i) + ai(i,l)*tau(1,i))/f
	h = h + f * g
	g = 1.0 + g/f
	ar(i,l) = g*ar(i,l)
	ai(i,l) = g*ai(i,l)
	if (l .eq. 1) go to 270
	go to 170
  160	tau(1,l) = -tau(1,i)
	si = tau(2,i)
	ar(i,l) = g
  170 	f = 0.0
c
	do 240 j = 1,l
	g = 0.0
	gi = 0.0
c form element of a*u
	do 180 k = 1,j
	g = g + ar(j,k)*ar(i,k) + ai(j,k)*ai(i,k)
	gi = gi - ar(j,k)*ai(i,k) + ai(j,k)*ar(i,k)
  180	continue
c
	jp1 = j+1
	if (l .lt. jp1) go to 220
c
	do 200 k = jp1,l
	g = g + ar(k,j)*ar(i,k) - ai(k,j)*ai(i,k)
	gi = gi - ar(k,j)*ai(i,k) - ai(k,j)*ar(i,k)
  200 	continue
c Form element of p
  220	e(j) = g/h
	tau(2,j) = gi/h
	f = f+ e(j)*ar(i,j) - tau(2,j)*ai(i,j)
  240	continue
c
	hh = f/(h + h)
c Form reduced a
	do 260 j = 1,l
	f = ar(i,j)
	g = e(j) - hh*f
	e(j) = g
	fi = -ai(i,j)
	gi = tau(2,j) - hh * fi
	tau(2,j) = -gi
c
	do 260 k = 1,j
	ar(j,k)= ar(j,k)-f*e(k)-g*ar(i,k)+fi*tau(2,k)+gi*ai(i,k)
	ai(j,k)= ai(j,k)-f*tau(2,k)-g*ai(i,k)-fi*e(k)-gi*ar(i,k)
  260	continue
c
  270	do 280 k = 1,l
	ar(i,k) = scale*ar(i,k)
	ai(i,k) = scale*ai(i,k)
  280	continue
c
	tau(2,l) = -si
  290	hh = d(i)
	d(i) = ar(i,i)
	ar(i,i) = hh
	ai(i,i) = scale*dsqrt(h)
  300	continue
c
	return
	end
















	subroutine htribk(nm,n,ar,ai,tau,m,zr,zi)
	implicit double precision (a-h,o-z)
	dimension ar(nm,n),ai(nm,n),tau(2,n),zr(nm,n),zi(nm,n)
c
	if (m .eq. 0) go to 200
c
c Transform the E'vectors of the real symmetric tridiagonal
c matrix to those of the Hermitian tridiagonal matrix
c
	do 50 k = 1,n
c
	do 50 j = 1,m
	zi(k,j) = -zr(k,j)*tau(2,k)
	zr(k,j) = zr(k,j)*tau(1,k)
   50	continue
c
	if (n .eq. 1) go to 200
c Recover and apply the Householder Matrices
	do 140 i = 2,n
	l = i-1
	h = ai(i,i)
	if (h .eq. 0.0) go to 140
c
	do 130 j = 1,m
	s = 0.0
	si = 0.0
c
	do 110 k = 1,l
	s=s+ar(i,k)*zr(k,j)-ai(i,k)*zi(k,j)
	si = si + ar(i,k)*zi(k,j) + ai(i,k)*zr(k,j)
  110	continue
c Double divisions avoid possible underflow
	s = (s/h)/h
	si = (si/h)/h
c
	do 120 k = 1,l
	zr(k,j) = zr(k,j) - s*ar(i,k) - si*ai(i,k)
	zi(k,j) = zi(k,j) - si*ar(i,k) + s*ai(i,k)
  120	continue
  130	continue
  140	continue
  200	return
	end












	subroutine tred2(nm,n,a,d,e,z)
c
	implicit double precision (a-h,o-z)
	double precision a(nm,n), d(n),e(n),z(nm,n)
	double precision f,g,h,hh,scale
	integer i,j,k,l,n,ii,nm,jp1
c
	do 100 i = 1,n
	do 100 j = 1,i
	z(i,j) = a(i,j)
 100	continue
c
	if (n .eq. 1) go to 320
c for i = n step -1 until 2 do --
	do 300 ii = 2,n
	i = n + 2 - ii
	l = i - 1
	h = 0.0
	scale = 0.0
	if (l .lt. 2) go to 130
c scale row (algol tol then not needed)
	do 120 k = 1,l
 120	scale = scale + dabs(z(i,k))
c
	if (scale .ne. 0.0) go to 140
 130	e(i) = z(i,l)
	go to 290
c
 140	do 150 k = 1,l
	z(i,k) = z(i,k)/scale
	h = h + z(i,k) * z(i,k)
 150	continue
c
	f = z(i,l)
	g = -dsign(dsqrt(h),f)
	e(i) = scale * g
	h = h - f * g
	z(i,l) = f - g
	f = 0.0
c
	do 240 j = 1,l
	z(j,i) = z(i,j)/h
	g = 0.0
c form element of a*u
	do 180 k = 1,j
 180	g = g + z(j,k) * z(i,k)
c
	jp1 = j + 1
	if (l .lt. jp1) go to 220
c
	do 200 k = jp1,l
 200	g = g + z(k,j) * z(i,k)
c form element of p
 220	e(j) = g/h
	f = f + e(j) * z(i,j)
 240	continue
c
	hh = f/(h + h)
c form reduced a
	do 260 j = 1,l
	f = z(i,j)
	g = e(j) - hh * f
	e(j) = g
c
	do 260 k = 1,j
	z(j,k) = z(j,k) - f * e(k) - g * z(i,k)
 260	continue
c
 290	d(i) = h
 300	continue
c
 320	d(1) = 0.0
	e(1) = 0.0	
c accumulation of transformation matrices
	do 500 i = 1,n
	l = i - 1
	if (d(i) .eq. 0.0) go to 380
c
	do 360 j = 1,l
	g = 0.0
c
	do 340 k = 1,l
 340	g = g + z(i,k) * z(k,j)
c
	do 360 k = 1,l
	z(k,j) = z(k,j) - g * z(k,i)
 360	continue
c
 380	d(i) = z(i,i)
	z(i,i) = 1.0
	if (l .lt. 1) go to 500
c
	do 400 j = 1,l
	z(i,j) = 0.0
	z(j,i) = 0.0
 400	continue
c
 500	continue
c
	return
	end















C TQL2 RENAMED TO MAINTAIN COMPATIBILITY WITH FPS
	subroutine imtql2(nm,n,d,e,z,ierr)
c	
	integer i,j,k,l,m,n,ii,l1,nm,mml,ierr
	double precision d(n),e(n),z(nm,n)
	double precision b,c,f,g,h,p,r,s,machep
c
c	machep is a machine dependent parameter specifying the relative precision of floating point
c	arithmetic
c
c
	machep = 2.0d-11
c
	ierr = 0
	if (n .eq. 1) go to 1001
c
	do 100 i = 2, n
  100	e(i-1) = e(i)
c
	f = 0.0
	b = 0.0
	e(n) = 0.0
c
	do 240 l = 1, n
	   j = 0
	   h = machep * (dabs(d(l)) + dabs(e(l)))
	   if (b .lt. h) b = h
c       look for small sub-diagonal element
	   do 110 m = l, n
	      if (dabs(e(m)) .le. b) go to 120
c	e(n) is always zero, so there is no exit through the bottom of the loop
  110      continue 
c
  120	   if (m .eq. l) go to 220
  130	   if (j .eq. 30) go to 1000
	   j = j + 1
c	form shift  
	   l1 = l + 1
	   g = d(l)
	   p = (d(l1) - g) / (2.0 * e(l))
	   r = dsqrt(p*p+1.0)
	   d(l) = e(l) / (p + dsign(r,p))
	   h = g - d(l)
c
	   do 140 i =l1, n
  140	   d(i) = d(i) - h
c
	   f = f + h
c	ql transformation
	   p = d(m)
	   c = 1.0
	   s = 0.0
	   mml = m - l
c	for i=m-1 step -1 until l do --
	do 200 ii = 1, mml
	   i = m - ii
	   g = c * e(i)
	   h = c * p
	   if (dabs(p) .lt. dabs(e(i))) go to 150
	   c = e(i) / p
	   r = dsqrt(c*c+1.0)
	   e(i+1) = s * p * r
	   s = c / r
	   c = 1.0 / r
	   go to 160
  150	   c = p / e(i)
	   r = dsqrt(c*c+1.0)
	   e(i+1) = s * e(i) * r
	   s =1.0 / r
	   c = c * s
  160	   p = c * d(i) -  s * g
	   d(i+1) = h + s * (c * g + s * d(i))
c	form vector
	   do 180 k = 1, n
	      h = z(k,i+1)
	      z(k,i+1) = s * z(k,i) + c * h
	      z(k,i) = c * z(k,i) - s * h
  180	   continue
c
  200	continue
c
	e(l) = s * p
	d(l) = c * p
	if (dabs(e(l)) .gt. b) go to 130
  220	d(l) = d(l) + f
  240  	continue

c	order eigenvalues and eigenvectors
	do 300 ii = 2, n
	   i = ii - 1
	   k = i
	   p = d(i)
c
	   do 260 j = ii, n
	      if (d(j) .ge. p) go to 260
	      k = j
	      p = d(j)
  260     continue
c	
	  if (k .eq. i) go to 300
	  d(k) = d(i)
	  d(i) = p
c
	  do 280 j = 1, n
	     p = z(j,i)
	     z(j,i) = z(j,k)
	     z(j,k) = p
  280	  continue
c
  300	continue


c
	go to 1001
c	set error -- no convergence to an eigenvalue after 30 iterations
 1000	ierr = l
 1001	return
	end
	







