/*============================================================================*/
/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> CG_IAR.C <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/
/*============================================================================*/

#include 	 	"com_iar.h"


short CgChkFile( void ) ;
short CgMakeFile( void ) ;
short DAlloc1Dim( double **ptpt, long sz ) ;
void DFree1Dim( double **ptpt ) ;






/*OPEN OR CREATE FILE CONTAINING CLEBSCH GORDAN SYMBOLS FOR MAXIMUM J*/
short CgChkFile()
   {
   int cg_fd ;
   long j_max ;



/*COPY FILE NAME FOR GLOBAL ACCESS*/
   strcpy( Cg_flnm, "/usr/local/CG" ) ;

/*CLEBSCH GORDAN FILE DOES NOT EXIST -> CREATE ONE CONTAINING CLEBSCH GORDAN SYMBOLS FOR MAXIMUM J*/
   if( (cg_fd = open( Cg_flnm, O_RDONLY | O_BINARY )) == -1 )
      {

   /*COPY FILE NAME FOR GLOBAL ACCESS*/
      strcpy( Cg_flnm, "CG" ) ;

   /*CLEBSCH GORDAN FILE DOES NOT EXIST -> CREATE ONE CONTAINING CLEBSCH GORDAN SYMBOLS FOR MAXIMUM J*/
      if( (cg_fd = open( Cg_flnm, O_RDONLY | O_BINARY )) == -1 )
         {

      /*INFORM USER*/
         fprintf( Log_fp, "'CG' (CLEBSCH-GORDAN) DOES NOT EXIST: CREATING FILE FOR J MAX = %ld\n", J_max ) ;

      /*CREATE NEW FILE*/
         if( CgMakeFile() == -1 )
            return( -1 ) ;

      /*RETURN SUCCESS*/
         else
            return( 1 ) ;
         }
      }


/*CLEBSCH GORDAN FILE EXISTS -> READ MAXIMUM J VALUE CALCULATED*/
   read( cg_fd, (char *)&j_max, sizeof( long ) ) ;
      
/*CLOSE FILE*/
   close( cg_fd ) ;


/*MAXIMUM J EXCEEDS TABLE VALUES -> CREATE NEW FILE*/
   if( J_max > j_max )
      {

   /*INFORM USER*/
      fprintf( Log_fp, "'CG' (CLEBSCH-GORDAN) EXISTS BUT J MAX = %ld EXCEEDS %ld IN FILE: CREATING !\n", J_max, j_max ) ;

   /*MAKE NEW FILE*/
      if( CgMakeFile() == -1 )
         return( -1 ) ;
      }


/*FILE EXISTS AND J MAX OK*/
   else
      fprintf( Log_fp, "'CG' (CLEBSCH-GORDAN) EXISTS AND TABLE J MAX = %ld !\n", j_max ) ;


/*RETURN SUCCESS*/
   return( 1 ) ;
   }









/*MAKE FILE CONTAINING WIGNER 3-J SYMBOLS -> MATRIX <row||col> = <j''k''||j'k'> */
short CgMakeFile()
   {
   int cg_fd ;
   long cg_dim ;
   long jg_qn, je_qn ;
   long k_ct, k_qn ;
   long g_dim, e_dim ;
   double *cg_mat, *cg_ary ;


/*CAN'T CREATE FILE CONTAINING CLEBSCH GORDAN SYMBOLS FOR MAXIMUM J IN /USR/LOCAL*/
   if( (cg_fd = open( Cg_flnm, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
      {

   /*COPY FILE NAME FOR GLOBAL ACCESS*/
      strcpy( Cg_flnm, "CG" ) ;


   /*CAN'T CREATE FILE CONTAINING CLEBSCH GORDAN SYMBOLS FOR MAXIMUM J IN HOME DIRECTORY*/
      if( (cg_fd = open( Cg_flnm, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666 )) == -1 )
         {
         fprintf( Log_fp, "\nCGMAKEFILE -> CAN'T CREATE FILE '/usr/local/CG' OR 'CG' !\n" ) ;
         return( -1 ) ;
         }
      }


/*ALLOCATE SPACE FOR LARGEST WIGNER 3J MATRIX -> Q BRANCH TRANSITIONS OF J MAX*/
   cg_dim = (2 * J_max + 1) * (2 * J_max + 1) ;

/*INITIALIZE POINTER AND ALLOCATE SPACE*/
   cg_mat = NULL ;
   if( DAlloc1Dim( &cg_mat, cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nCGMAKEFILE (CG_MAT) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }


/*ALLOCATE SPACE FOR LARGEST WIGNER 3J ARRAY*/
   cg_dim = 18 * J_max + 1 ;

/*INITIALIZE POINTER AND ALLOCATE SPACE*/
   cg_ary = NULL ;
   if( DAlloc1Dim( &cg_ary, cg_dim ) == -1 )
      {
      fprintf( Log_fp, "\nCGMAKEFILE (CG_ARY) -> CAN'T ALLOCATE ENOUGH SPACE !\n" ) ;
      return( -1 ) ;
      }



/*WRITE MAXIMUM J CALCULATED IN FILE FIRST*/
   write( cg_fd, (char *)&J_max, sizeof( long ) ) ;


/*LOOP THROUGH ALL GROUND J FROM 0 TO J MAX*/
   for( jg_qn = 0; jg_qn <= J_max; jg_qn++ )
      {

   /*CALCULATE GROUND STATE J DIMENSION*/
      g_dim = 2 * jg_qn + 1 ;


   /*LOOP THROUGH ALL EXCITED J FROM JG - 1 TO JG + 1*/
      for( je_qn = (jg_qn != 0) ? jg_qn - 1 : 1; je_qn <= jg_qn + 1 && je_qn <= J_max; je_qn++ )
         {

      /*CALCULATE EXCITED STATE J DIMENSION*/
         e_dim = 2 * je_qn + 1 ;



      /*ERROR ANALYSIS -> ZERO MATRIX -> NOT NECESSARY FOR CALCULATION*/
         if( Err == 1 )
            for( k_ct = 0; k_ct < g_dim * e_dim; k_ct++ )
               *(cg_mat + k_ct) = 0.0 ;



      /*P BRANCH TRANSITIONS*/
         if( jg_qn == je_qn + 1 )
            {


         /*PARALLEL TYPE -> DELTA K = ZERO -> <row||col> = <j k'||j k'>*/
            for( k_qn = -je_qn, k_ct = 0; k_ct < e_dim; k_ct++, k_qn++ )
               *(cg_mat + (k_ct + 1) * e_dim + k_ct) = 
                     -1.0 * sqrt( (double)(jg_qn - k_qn) * (jg_qn + k_qn) / jg_qn ) ;


         /*PERPENDICULAR TYPE -> DELTA K = PLUS ONE -> <row - 1||col> = <j k' - 1||j k'>*/
            for( k_qn = -je_qn, k_ct = 0; k_ct < e_dim; k_ct++, k_qn++ )
               *(cg_mat + k_ct * e_dim + k_ct) = 0.5 *
                     sqrt( (double)(jg_qn - k_qn) * (jg_qn - k_qn + 1) / jg_qn ) ;


         /*PERPENDICULAR TYPE -> DELTA K = MINUS ONE -> <row - 1||col> = <j k' - 1||j k'>*/
            for( k_qn = -je_qn, k_ct = 0; k_ct < e_dim; k_ct++, k_qn++ )
               *(cg_mat + (k_ct + 2) * e_dim + k_ct) = 0.5 *
                     sqrt( (double)(jg_qn + k_qn + 1) * (jg_qn + k_qn) / jg_qn ) ;



         /*CALCULATE DIMENSION OF WIGNER 3J ARRAY*/
            cg_dim = 6 * jg_qn - 3 ;

         /*COPY TRIDIAGONAL MATRIX ELEMENTS TO SINGLE ARRAY*/
            for( k_qn = 0, k_ct = 0; k_ct < cg_dim; k_ct += 3, k_qn++ )
               {
               *(cg_ary + k_ct + 0) = *(cg_mat + (k_qn + 0) * e_dim + k_qn) ;
               *(cg_ary + k_ct + 1) = *(cg_mat + (k_qn + 1) * e_dim + k_qn) ;
               *(cg_ary + k_ct + 2) = *(cg_mat + (k_qn + 2) * e_dim + k_qn) ;
               }

         /*WRITE SINGLE ARRAY TO FILE*/
            write( cg_fd, (char *)cg_ary, cg_dim * sizeof( double ) ) ;



         /*ERROR ANALYSIS*/
            if( Err == 1 )
               {

            /*PRINT WIGNER 3J MATRIX*/
               printf( "CG P BRANCH %ld %ld\n", jg_qn, je_qn ) ;
               for( k_ct = 0; k_ct < g_dim; k_ct++ )        
                  {
                  for( k_qn = 0; k_qn < e_dim; k_qn++ )
                     printf( "%10.2e", *(cg_mat + k_ct * e_dim + k_qn) ) ;

                  printf( "\n" ) ;
                  }
               printf( "\n" ) ;

            /*PRINT WIGNER 3J SYMBOLS SAVED*/
               for( k_ct = 0; k_ct < cg_dim; k_ct++ )        
                  printf( "%10.2e", *(cg_ary + k_ct) ) ;
               printf( "\n" ) ;
               }
            }




      /*Q BRANCH TRANSITIONS*/
         else if( jg_qn == je_qn )
            {


         /*PARALLEL TYPE -> DELTA K = ZERO -> <row||col> = <j k'||j k'>*/
            for( k_qn = -jg_qn, k_ct = 0; k_ct < g_dim; k_ct++, k_qn++ )
               *(cg_mat + k_ct * e_dim + k_ct) = (double)k_qn * 
                     sqrt( (double)(2.0 * jg_qn + 1) / (jg_qn * (jg_qn + 1)) ) ;


         /*PERPENDICULAR TYPE -> DELTA K = PLUS ONE -> <row - 1||col> = <j k' - 1||j k'>*/
            for( k_qn = -jg_qn + 1, k_ct = 1; k_ct < g_dim; k_ct++, k_qn++ )
               *(cg_mat + (k_ct - 1) * e_dim + k_ct) = -0.5 *
                     sqrt( (double)(jg_qn + k_qn) * (jg_qn - k_qn + 1) / (jg_qn * (jg_qn + 1)) *
                     (2.0 * jg_qn + 1) ) ;


         /*PERPENDICULAR TYPE -> DELTA K = PLUS ONE -> <row - 1||col> = <j k' - 1||j k'>*/
            for( k_qn = -jg_qn, k_ct = 0; k_ct < g_dim - 1; k_ct++, k_qn++ )
               *(cg_mat + (k_ct + 1) * e_dim + k_ct) = 0.5 *
                     sqrt( (double)(jg_qn - k_qn) * (jg_qn + k_qn + 1) / (jg_qn * (jg_qn + 1)) *
                     (2.0 * jg_qn + 1) ) ;



         /*CALCULATE DIMENSION OF WIGNER 3J ARRAY*/
            cg_dim = 6 * jg_qn ;

         /*COPY TRIDIAGONAL MATRIX ELEMENTS TO SINGLE ARRAY*/
            for( k_qn = 0, k_ct = 0; k_ct < cg_dim; k_ct += 3, k_qn++ )
               {
               *(cg_ary + k_ct + 0) = *(cg_mat + k_qn * e_dim + k_qn) ;
               *(cg_ary + k_ct + 1) = *(cg_mat + k_qn * e_dim + (k_qn + 1)) ;
               *(cg_ary + k_ct + 2) = *(cg_mat + (k_qn + 1) * e_dim + k_qn) ;
               }

         /*LAST DIAGONAL ELEMENT*/
            *(cg_ary + cg_dim) = *(cg_mat + k_qn * e_dim + k_qn) ;

         /*WRITE SINGLE ARRAY TO FILE*/
            cg_dim++ ;
            write( cg_fd, (char *)cg_ary, cg_dim * sizeof( double ) ) ;


         /*ERROR ANALYSIS*/
            if( Err == 1 )
               {

            /*PRINT WIGNER 3J MATRIX*/
               printf( "CG Q BRANCH %ld %ld\n", jg_qn, je_qn ) ;
               for( k_ct = 0; k_ct < g_dim; k_ct++ )        
                  {
                  for( k_qn = 0; k_qn < e_dim; k_qn++ )
                     printf( "%10.2e", *(cg_mat + k_ct * e_dim + k_qn) ) ;
                  printf( "\n" ) ;
                  }
               printf( "\n" ) ;

            /*PRINT WIGNER 3J SYMBOLS SAVED*/
               for( k_ct = 0; k_ct < cg_dim; k_ct++ )        
                  printf( "%10.2e", *(cg_ary + k_ct) ) ;
               printf( "\n" ) ;
               }
            }


 
      /*R BRANCH TRANSITIONS*/
         else if( jg_qn + 1 == je_qn )
            {


         /*PARALLEL TYPE -> DELTA K = ZERO -> <row||col> = <j k'||j k'>*/
            for( k_qn = -jg_qn, k_ct = 0; k_ct < g_dim; k_ct++, k_qn++ )
               *(cg_mat + k_ct * e_dim + (k_ct + 1)) =
                     sqrt( (double)(jg_qn - k_qn + 1) * (jg_qn + k_qn + 1) / (jg_qn + 1) ) ;


         /*PERPENDICULAR TYPE -> DELTA K = PLUS ONE -> <row - 1||col> = <j k' - 1||j k'>*/
            for( k_qn = -jg_qn + 1, k_ct = 0; k_ct < g_dim; k_ct++, k_qn++ )
               *(cg_mat + k_ct * e_dim + (k_ct + 2)) =
                     sqrt( (double)(jg_qn + k_qn) * (jg_qn + k_qn + 1) / (2.0 * (2.0 * jg_qn + 2)) ) ;


         /*PERPENDICULAR TYPE -> DELTA K = MINUS ONE -> <row - 1||col> = <j k' - 1||j k'>*/
            for( k_qn = -jg_qn - 1, k_ct = 0; k_ct < g_dim; k_ct++, k_qn++ )
               *(cg_mat + k_ct * e_dim + k_ct) =
                     sqrt( (double)(jg_qn - k_qn) * (jg_qn - k_qn + 1) / (2.0 * (2.0 * jg_qn + 2)) ) ;



         /*CALCULATE DIMENSION OF WIGNER 3J ARRAY*/
            cg_dim = 6 * jg_qn + 3 ;

         /*COPY TRIDIAGONAL MATRIX ELEMENTS TO SINGLE ARRAY*/
            for( k_qn = 0, k_ct = 0; k_ct < cg_dim; k_ct += 3, k_qn++ )
               {
               *(cg_ary + k_ct + 0) = *(cg_mat + k_qn * e_dim + (k_qn + 0)) ;
               *(cg_ary + k_ct + 1) = *(cg_mat + k_qn * e_dim + (k_qn + 1)) ;
               *(cg_ary + k_ct + 2) = *(cg_mat + k_qn * e_dim + (k_qn + 2)) ;
               }

         /*WRITE SINGLE ARRAY TO FILE*/
            write( cg_fd, (char *)cg_ary, cg_dim * sizeof( double ) ) ;


         /*ERROR ANALYSIS*/
            if( Err == 1 )
               {

            /*PRINT WIGNER 3J MATRIX*/
               printf( "CG R BRANCH %ld %ld\n", jg_qn, je_qn ) ;
               for( k_ct = 0; k_ct < g_dim; k_ct++ )
                  {
                  for( k_qn = 0; k_qn < e_dim; k_qn++ )
                     printf( "%10.2e", *(cg_mat + k_ct * e_dim + k_qn) ) ;
                  printf( "\n" ) ;
                  }
               printf( "\n" ) ;

            /*PRINT WIGNER 3J SYMBOLS SAVED*/
               for( k_ct = 0; k_ct < cg_dim; k_ct++ )        
                  printf( "%10.2e", *(cg_ary + k_ct) ) ;
               printf( "\n" ) ;
               }
            }
         }
      }


/*CLOSE CLEBSCH GORDAN FILE FOR WRITING*/
   close( cg_fd ) ;


/*FREE TEMPORARY SPACE*/
   DFree1Dim( &cg_ary ) ;
   DFree1Dim( &cg_mat ) ;


/*RETURN SUCCESS*/
   return( 1 ) ;
   }



