// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 , USA
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.
//


#ifndef KROT_DIALOG_PROGRESS_H
#define KROT_DIALOG_PROGRESS_H



#include <qdialog.h>

#include <kprogress.h>


class DialogProgress : public QDialog
{
    Q_OBJECT

public:
    
    DialogProgress( QWidget *parent, const char *caption, const char *text, int val=0, int min=0, int max=100 );


public slots:

    /**
     * Set new value of progress bar
     *
     * @param val New progress bar value
     */
    void setValue( int val );


protected slots:

    /**
     * Cancel pressed, emit abort.
     */
    void cancel();


signals:
    
    /**
     * The user pressed cancel, abort operation.
     */
    void abort();


private:
    
    KProgress *progress;
};



#endif
