// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 , USA
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.
//



#include "lined.h"

#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qvalidator.h> 

#include <cfloat>
#include <cstdio>
#include <cstdlib>



ChkLblFloated::ChkLblFloated( const char *text, const int prec, const double value,
			      QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    mark = new QCheckBox( text, this );
    mark->setFixedWidth( mark->sizeHint().width() + 5 );
    edit = new Floated( prec, value, this );
    QBoxLayout *layout = new QHBoxLayout( this );
    layout->addWidget( mark );
    layout->addWidget( edit );
    layout->activate();
    setMinimumHeight( sizeHint().height() );
    resize( sizeHint() );
    connect( mark, SIGNAL( toggled( bool ) ),
	     this, SLOT( slotToggled( bool ) ) );
    return;
}



Floated::Floated( const int prec, const double value, QWidget *parent, const char *name )
    : QLineEdit( parent, name ),
      precision( prec )
{
    QValidator *validator = new QDoubleValidator( DBL_MIN, DBL_MAX, prec, parent, name );
    setValidator( validator );
    setValue( value );
    setFixedHeight( sizeHint().height() );
    resize( sizeHint() );
    return;
}



LblFloated::LblFloated( const char *text, const int prec, const double value,
			QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    label = new QLabel( text, this );
    label->setFixedWidth( label->sizeHint().width() + 5 );
    edit = new Floated( prec, value, this );
    label->setBuddy( edit );
    QBoxLayout *layout = new QHBoxLayout( this );
    layout->addWidget( label );
    layout->addWidget( edit );
    layout->activate();
    setMinimumHeight( sizeHint().height() );
    resize( sizeHint() );
    return;
}



LblInted::LblInted( const char *text, const int min, const int max, const int value,
		    QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    label = new QLabel( text, this );
    label->setFixedWidth( label->sizeHint().width() + 5 );
    edit = new Inted( min, max, value, this );
    label->setBuddy( edit );
    QBoxLayout *layout = new QHBoxLayout( this );
    layout->addWidget( label );
    layout->addWidget( edit );
    layout->activate();
    setMinimumHeight( sizeHint().height() );
    resize( sizeHint() );
    return;
}



Inted::Inted( const int min, const int max, const int value, QWidget *parent, const char *name )
    : QLineEdit( parent, name )
{
    QValidator *validator = new QIntValidator( min, max, parent, name );
    setValidator( validator );
    setValue( value );
    setFixedHeight( sizeHint().height() );
    resize( sizeHint() );
    return;
}



//* Local Variables:
//* mode: C++
//* c-file-style: "Stroustrup"
//* End:
