// -*- mode: C++; c-file-style: "Stroustrup" -*-
//
// This file is part of krot,
// a program for the simulation, assignment and fit of HRLIF spectra.
//
// Copyright (C) 1998,1999 Jochen Kpper
//
// This program is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation; either version 2 of the License, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// this program; see the file License. if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 , USA
//
// If you use this program for your scientific work, please cite it according to
// the file CITATION included with this package.
//



#ifndef KROT_DIALOG_EDIT_ASSIGNMENTS_H
#define KROT_DIALOG_EDIT_ASSIGNMENTS_H


#include <qdialog.h>


class AssignedFrequency;
class Floated;
class KNumericSpinBox;
class KRotData;
class QListView;



/**
 * Edit an assignment.
 *
 * @author Jochen Kpper
 * @version 1998/12/02
 */
class DialogEditSingleAssignment : public QDialog
{
    Q_OBJECT

public:

    /**
     * Create a dialog to edit an AssignedFrequency.
     * This constructor does not show the dialog.
     */
    DialogEditSingleAssignment( QWidget* parent=0, const char* name=0 );

    /**
     * Get current values.
     */
    const AssignedFrequency getValues() const;

    /**
     * Set values.
     */
    void setValues( const AssignedFrequency& asn );


protected slots:

    void help();

    
protected:

    KNumericSpinBox *qnum[ 6 ];

    Floated *freq;
};



/**
 *
 * @short Edit assignments by "hand".
 * @author Jochen Kpper
 * @version 1998/12/02
 */
class DialogEditAssignments : public QDialog
{
    Q_OBJECT

public:
    
    DialogEditAssignments( KRotData *krotdata, QWidget* parent=0, const char* name=0 );

    virtual ~DialogEditAssignments();
 

protected slots:

    void help();

    void edit();

    void del();

    virtual void resizeEvent( QResizeEvent * );


protected:

    void updateList();


protected:

    DialogEditSingleAssignment *editor;
    
    QListView *list;

    KRotData *krotData;
};



#endif
