#ifndef _LINREG_H_
#define _LINREG_H_


#include <kconfig.h>
#include "fitter.h"


/** Fitter for Linear Regression.


	An example for a concrete fitter. Though mathematically simple,
	this is used as a test case for the fitting model draft.

	Mathematically, it computes:

    S1 = sum xi * yi

    S2 = sum xi

    S3 = sum yi

    S4 = sum x^2

	slope = (n * s1 - s2 * s3) / (n * s4 - s2 * s2);

	intercept = (s3 - slope * s2) / n;

	@see Fitter
	@author Patrick Schemitz
*/

class LinearRegression : public Fitter
{
public:
  /** Constructor.

	  Initializes slope and intercept to zero.
  */
  LinearRegression ();

  /// Returns the name of the fitter "Linear Regression".
  const char* name () { return "Linear Regression"; }

  /// Currently does nothing.
  int execOptionsDialog ();

  /** Returns the number of input columns, 2.

	  Since linear regression requires 2 input columns, namely "x"
	  and "y", this function returns 2. O wonder.
  */
  int getInputColumnCount ();

  /** Returns the number of output columns, 1.

	  The linear regression fitter generates truely linear y's for
	  each "x" input.
  */
  int getOutputColumnCount ();

  /** Returns the name of ith input column.

	  For i=0, returns "X". For i=1, returns "Y".
  */
  const char* getInputColumnName (int i);

  /** Returns the name of the output column, "Y linear".

	  Does so for i=0. For all other values of i, it insults the caller.
  */
  const char* getOutputColumnName (int i);

  /** Does the actual fit.

	  In this function, the linear regression is actually
	  computed, and the output column is filled.
  */
  bool fit ();

  /// Currently does nothing.
  void saveSettings (KConfig*);
  /// Currently does nothing.
  void loadSettings (KConfig*);

private:
  /** slope of the ausgleichsgerade.

	  @see intercept
  */
  double slope;

  /** intercept of the ausgleichsgerade.

	  @see slope
  */
  double intercept;
};


#endif
