#ifndef __IMPORTASCII_H
#define __IMPORTASCII_H 


#include <qobject.h>
#include <qstring.h>

#include <kconfig.h>

#include "import.h"

#include "firstLine.h"
#include "readArea.h"
#include "filterWidget.h"


/**
 *    @short Import ASCII files.
 *
 *    Clone this file for further import filters.
 *
 *    Dont copy this file into the korigin include path!
 *    It is not needed there.
 *
 *    When writing new filters watch the initialization class
 *    in the importASCII.cc file (at the end).
 *
 *    @author Martin Hfner (mh@ap-dec717c.physik.uni-karlsruhe.de)
 *    @version 0.1
 *    @see importFilter
 */
class importASCII : public QObject, public importFilter
{
  Q_OBJECT
  public: 

    /**
     *  Does nothing until now.
     */
    importASCII ();

    /**
     *  Does nothing until now.
     */
    ~importASCII ();
    
    /**
     *  All import Filter have an entry in the korigin menus. This is the
     *  name, under which this module will appear.
     *
     *  @return "ASCII"
     */
    QString getDescription ();

    /**
     *  The File Dialog needs a filter string, e.g. "*.html".
     *
     *  @return the file filter defined in the options tabdialog or "*.dat"
     *          if nothing is defined.
     */
    const char* getFileFilter ();

    /**
     *  Builds a complete options tabdialog inclusive slots. All options
     *  dialogw must have a file filter dialog.
     */
    void getOptionsSlot ();

    /**
     *  The main function. Reads a table ins a way defined by the options 
     *  dialog (skipping headers...).
     *
     *  @param filename   the name of the file to read from disk
     *  @return a pointer to the allocated Table object
     */
    Table* readTable (const char* filename);

    /**
     *  All import filters have there own recent directory buffer. This
     *  will be be configurable in later versions. 
     *
     *  @return the latest used directory when importing an ASCII file.
     *  @see #getDefaultDirectory
     */
    QString getLatestDirectory ();

    /**  
     *  @param dir   the latest used directory when importing an ASCII file.
     *  @see #getLatestDirectory
     */
    void setLatestDirectory (const char* dir);

    /**
     *  When launching the application, the first time importing an ASCII
     *  file this directory will be be directory displayed by the file
     *  dialog.
     *
     *  @return the predefined default directory
     */
    QString getDefaultDirectory ();

    /**
     *  The defaultDirectory will be configurable through an options dialog.
     *
     *  @param dir   the default directory for this module
     */
    void setDefaultDirectory (const char* dir);

  private:
    char getDivider (const char* line);
    QString getNextEntry (QString s, const char divider);
    QString stripEntry (QString s, QString entry);
    bool isDouble (QString entry);

    KConfig* k;
    readArea* ra;
    firstLine* fl;
    filterWidget* fw;

    QString latestDirectory;

  private slots:
    void applyPressed ();
};



#endif

