#ifndef __WS_TABLEDATA_H
#define __WS_TABLEDATA_H


#include <qlined.h>
#include <qtablevw.h>
#include <qevent.h>
#include <qpoint.h>


class Worksheet;


class TableInput : public QLineEdit
  {
    Q_OBJECT
    public:
      TableInput (QWidget* parent=0, const char* name=0);
    protected:
      void keyPressEvent (QKeyEvent*);
  };
  


class TableData : public QTableView
  {
    friend class TableHead;
    Q_OBJECT
    public:
      TableData (int numRows, int numCols, QWidget* parent=0, const char* name=0);
      ~TableData ();

      // get and set the cellcontent from and to Mr. M
      const char* getCellContent( int row, int col ) const;
      void setCellContent( int row, int col, const char* );

      // check for whether displaying the infield or not. Will be set by
      // widgets which make a highlight event 
      void setFocus (bool);
      bool hasFocus ();

    signals:
      void changeActiveWS ();

    public slots:
      void returnInput();
      void resizeTableData (int numRows, int numCols);

      // will be called by other TableViews and worksheet
      void update (int,int);

      // worksheet needs to change the view
      void changeTopCell (int row);
      void changeLeftCell (int col);

      void scrollDown ();
      void scrollUp ();

      void showCurrentColumnGrey ();
      void showCurrentColumnNormal ();
      void showCurrentRowGrey ();
      void showCurrentRowNormal ();

    private slots:
      void topCellChanged (int);    // these slots transform the slidervalue in
      void leftCellChanged (int);   // the top and left upper cell visible

      void colorsChanged();

    signals:
      // this signals will be emitted to TableHead and TableFirstColumn
      void topCellHasChanged (int);
      void leftCellHasChanged (int);

    protected:
      void paintCell( QPainter*, int row, int col );
      void mousePressEvent( QMouseEvent* );
      void mouseReleaseEvent ( QMouseEvent* );
      void mouseMoveEvent ( QMouseEvent* );
      void keyPressEvent( QKeyEvent* );
      void focusInEvent( QFocusEvent* );
      void focusOutEvent( QFocusEvent* );
      void paintEvent (QPaintEvent*);

    private:
      TableInput* infield;

      // the column which should be highlighted
      int showHighForPopupCol;
      int showHighForPopupRow;

      // check if the dataWidget really has the focus
      bool Focus;

      // I need the scrollbars for the headline and first column widgets
      const QScrollBar* vertScroll;
      const QScrollBar* horizScroll;

      // I need the Worksheet, because it knows Mr. M and a lot more
      Worksheet* myworksheet;

      // stores the mousePosition during mouseMoveEvents
      QPoint mouseOldPos;
   };



//
// this is the structure managed by worksheet to build the formula interpreter
// widget. All there used variables are saved 
//

struct fiData
  {
    QString formula;
    QString constants;
    int min;
    int max;
  };


#endif
