#include <stdlib.h>

#include "ws_normalizecolumn.h"

#include "ws_normalizecolumn.moc"


// ************************  the normalize widget  ****************************


void normalizeColumnWidget::normalizeColumn (int col, double divFactor)
  {
    int i;
    double help;
    char s1[40];

    int n = myworksheet->T->height (col);

    for (i=0; i<=n; i++)
      {
	help = atof ( myworksheet->T->cell (col, i) );
	sprintf (s1, "%g", help/divFactor); 
	myworksheet->T->setCell (col, i, s1);
      }
  }


double normalizeColumnWidget::getMinValue ()
  {
    int i;
    double help;

    int n = myworksheet->T->height (column);
    double min = atof ( myworksheet->T->cell (column, 0) );

    for (i=1; i<=n; i++)
      {
	help = atof ( myworksheet->T->cell (column, i) );
	if (help <= min) min = help;
      }

    return (min);
  }


double normalizeColumnWidget::getMaxValue ()
  {
    int i;
    double help;

    int n = myworksheet->T->height (column);
    double max = atof ( myworksheet->T->cell (column, 0) );

    for (i=1; i<=n; i++)
      {
	help = atof ( myworksheet->T->cell (column, i) );
	if (help >= max) max = help;
      }
    
    return (max);
  }


normalizeColumnWidget::normalizeColumnWidget
(
 int col,
	QWidget* parent,
	const char* name
)
	:
	QDialog( 0, name, TRUE )
{
  myworksheet = (Worksheet*) parent;
  column = col;

  double min = getMinValue ();
  double max = getMaxValue ();

  char s1[40];

  setCaption ("Normalize Column");

	rb1 = new QRadioButton( this, "RadioButton_1" );
	rb1->setGeometry( 35, 100, 85, 25 );
	rb1->setText( "divide by" );
	rb1->setAutoRepeat( FALSE );
	rb1->setAutoResize( FALSE );
	rb1->setChecked( TRUE );

	rb2 = new QRadioButton( this, "RadioButton_2" );
	rb2->setGeometry( 35, 140, 65, 25 );
	rb2->setText( "set y =" );
	rb2->setAutoRepeat( FALSE );
	rb2->setAutoResize( FALSE );

	divFactor = new QLineEdit( this, "LineEdit_4" );
	divFactor->setGeometry( 115, 100, 80, 25 );
	sprintf (s1, "%g", max);
	divFactor->setText( s1 );
	divFactor->setMaxLength( 40 );
	divFactor->setEchoMode( QLineEdit::Normal );
	divFactor->setFrame( TRUE );
	divFactor->selectAll ();

	setY = new QLineEdit( this, "LineEdit_5" );
	setY->setGeometry( 115, 140, 80, 25 );
	setY->setText( "" );
	setY->setMaxLength( 40 );
	setY->setEchoMode( QLineEdit::Normal );
	setY->setFrame( TRUE );
	setY->setEnabled (FALSE);

	lb3 = new QLabel( this, "Label_1" );
	lb3->setGeometry( 220, 140, 65, 25 );
	lb3->setText( "for row = " );
	lb3->setAlignment( 289 );
	lb3->setMargin( -1 );

	Line = new QLineEdit( this, "LineEdit_6" );
	Line->setGeometry( 285, 140, 60, 25 );
	Line->setText( "" );
	Line->setMaxLength( 10 );
	Line->setEchoMode( QLineEdit::Normal );
	Line->setFrame( TRUE );
	Line->setEnabled (FALSE);

	lb1 = new QLabel( this, "Label_2" );
	lb1->setGeometry( 35, 20, 160, 25 );
	lb1->setText( "Column contains data from " );
	lb1->setAlignment( 289 );
	lb1->setMargin( -1 );

	minLb = new QLabel( this, "Label_3" );
	minLb->setGeometry( 205, 20, 75, 25 );
	sprintf (s1, "%g", min);
	minLb->setText( s1 );
	minLb->setAlignment( 290 );
	minLb->setMargin( -1 );

	maxLb = new QLabel( this, "Label_4" );
	maxLb->setGeometry( 205, 45, 75, 25 );
	sprintf (s1, "%g", max);
	maxLb->setText( s1 );
	maxLb->setAlignment( 290 );
	maxLb->setMargin( -1 );

	lb2 = new QLabel( this, "Label_6" );
	lb2->setGeometry( 175, 45, 20, 25 );
	lb2->setText( "to" );
	lb2->setAlignment( 289 );
	lb2->setMargin( -1 );

	ok = new QPushButton( this, "PushButton_1" );
	ok->setGeometry( 35, 215, 90, 25 );
	connect( ok, SIGNAL(clicked()), SLOT(OkPressed ()) );
	ok->setText( "OK" );
	ok->setAutoRepeat( FALSE );
	ok->setAutoResize( FALSE );
	ok->setDefault (TRUE);

	apply = new QPushButton( this, "PushButton_2" );
	apply->setGeometry( 155, 215, 90, 25 );
	apply->setText( "Apply" );
	apply->setAutoRepeat( FALSE );
	apply->setAutoResize( FALSE );
	connect (apply, SIGNAL (clicked()), SLOT (applyNormalizing()));

	cancel = new QPushButton( this, "PushButton_3" );
	cancel->setGeometry( 275, 215, 90, 25 );
	connect( cancel, SIGNAL(clicked()), SLOT(reject ()) );
	cancel->setText( "Cancel" );
	cancel->setAutoRepeat( FALSE );
	cancel->setAutoResize( FALSE );

	bg = new QButtonGroup( this, "ButtonGroup_1" );
	bg->setGeometry( 15, 90, 360, 100 );
	bg->setTitle( "" );
	bg->setAlignment( 1 );
	bg->insert( rb1 );
	bg->insert( rb2 );
	bg->hide ();
	bg->lower();
	connect (bg, SIGNAL (clicked(int)), SLOT (changeMode(int)));

	divFactor->setFocus ();

	setFixedSize( 400, 265 );
}


normalizeColumnWidget::~normalizeColumnWidget ()
  {
    delete lb1;
    delete lb2;
    delete lb3;
    delete bg;
    delete rb1;
    delete rb2;
    delete cancel;
    delete ok;
    delete apply;
    delete minLb;
    delete maxLb;
    delete divFactor;
    delete setY;
    delete Line;
  }


void normalizeColumnWidget::applyNormalizing ()
  {
    char s1[40];

    if (rb1->isChecked ()) divider = atof (divFactor->text());
    else
      {
	double help = atof ( myworksheet->T->cell(column, atoi (Line->text())-1 ) );
	divider = help / atof (setY->text());
      }

    normalizeColumn (column, divider);
    myworksheet->repaint ();

    sprintf (s1, "%g", getMinValue ());
    minLb->setText( s1 ); 
    sprintf (s1, "%g", getMaxValue ());
    maxLb->setText( s1 ); 

    repaint ();
  }


void normalizeColumnWidget::OkPressed ()
  {
    if (rb1->isChecked ()) divider = atof (divFactor->text());
    else
      {
	double help = atof ( myworksheet->T->cell(column, atoi (Line->text())-1 ) );
	divider = help / atof (setY->text());
      }

    normalizeColumn (column, divider);
    myworksheet->repaint ();

    // exit the event loop and return to the worksheet
    accept ();
  }


void normalizeColumnWidget::changeMode (int nr)
  {
    if (nr == 1)
      {
	divFactor->setEnabled (FALSE);
	setY->setEnabled (TRUE);
	Line->setEnabled (TRUE);
	setY->setFocus ();
      }
    else
      {
	divFactor->setEnabled (TRUE);
	setY->setEnabled (FALSE);
	Line->setEnabled (FALSE);
	divFactor->setFocus ();
      }
  }

