#include "ws_highlighting.h"


// ***********************  the Highlighted class  ****************************


Highlighted::Highlighted ()
  {  
    setNoHighlight ();

    // which widget has brought the event
    hasHighlighted = new char [255];
  }


Highlighted::~Highlighted ()
  {
    delete hasHighlighted;
  }


bool Highlighted::isHighlighted ()
  {
    if ( mouseStartPos != QPoint (-2,-2) ) return (TRUE);
    else return (FALSE);
  }  


QPoint Highlighted::getMouseEndPos ()
  {
    return (mouseEndPos);
  }


QPoint Highlighted::getMouseStartPos ()
  {
    return (mouseStartPos);
  }


bool Highlighted::isHighlighted (int row, int col)
  {
    if ( ( row <=getLowerY () ) && ( row >= getUpperY () ) 
	 && ( col <= getRightX () ) && ( col >= getLeftX () ) ) 
      return (TRUE); 
    else return (FALSE);
  }


int Highlighted::getLeftX ()
  {
    if ( mouseStartPos.x () <= mouseEndPos.x () )
      return ( mouseStartPos.x () );
    else return ( mouseEndPos.x () );
  }


int Highlighted::getUpperY ()
  {
    if ( mouseStartPos.y () <= mouseEndPos.y () )
      return ( mouseStartPos.y () );
    else return ( mouseEndPos.y () );
  }


int Highlighted::getRightX ()
  {
    if ( mouseStartPos.x () <= mouseEndPos.x () )
      return ( mouseEndPos.x () );
    else return ( mouseStartPos.x () );
  }


int Highlighted::getLowerY ()
  {
    if ( mouseStartPos.y () <= mouseEndPos.y () )
      return ( mouseEndPos.y () );
    else return ( mouseStartPos.y () );
  }


void Highlighted::setMouseStartPos (QPoint p, char* name)
  {
    mouseStartPos = p;
    strcpy (hasHighlighted, name);
  }


char* Highlighted::whoHasHighlighted ()
  {
    return (hasHighlighted);
  }


void Highlighted::setMouseEndPos (QPoint p)
  {
    mouseEndPos = p;
  }


void Highlighted::setNoHighlight ()
  {
    // or something else that could never be highlighted (negativ)
    mouseStartPos = QPoint (-2,-2);
    mouseEndPos = QPoint (-2,-2);
  }


QArray<int> Highlighted::getSelectedColumns ()
  {
    int i, size;

    if (strcmp (hasHighlighted, "Thead") != 0) size = 0;
    else size = getRightX()-getLeftX()+1;

    QArray<int> a (size);

    if (strcmp (hasHighlighted, "Thead") == 0)
      {
	for (i=0; i<getRightX()-getLeftX()+1;i++)
	  a[i] = getLeftX()+i;
      }

    return (a);
  }


QArray<int> Highlighted::getSelectedRows ()
  {
    QArray<int> a;
    return (a);
  }


bool Highlighted::isColumnHighlighted (int col)
{
  if ((getRightX() == col) && (getLeftX() == col))
    return (TRUE);
  else return (FALSE);
}


bool Highlighted::isCompleteColumnHighlighted (int col)
{
  if (strcmp (hasHighlighted, "Thead") == 0)
    { 
      if ((getRightX() == col) && (getLeftX() == col))
        return (TRUE);
      else return (FALSE);
    }
  else return (FALSE);
}


QRect Highlighted::getSelectedArea ()
  {
    //
    // until now, nothing happens
    //
    QRect a;

    return (a);
  }


int Highlighted::getSelectedColumn ()
{
  if (getLeftX() == getRightX()) 
    return (getRightX());
  else return (-2);
}












