#include "ws_columntitle.h"

#include "worksheet.h"

// ****************************  new Column Title  ****************************


columnTitleWidget::columnTitleWidget (int col, QWidget* parent, const char* name)
  : QDialog (0, name, TRUE)
  {
    setFixedSize (250, 150);
    setCaption ("Set new Column Title");

    columnTitle = new QLineEdit (this);
    columnTitle->setGeometry (30, 20, 130, 25);
    columnTitle->setText (((Worksheet*)parent)->T->title (col));
    columnTitle->selectAll ();

    ok = new QPushButton ("Ok", this);
    ok->setGeometry (30, 60, 90, 25);
    ok->setDefault (TRUE);

    cancel = new QPushButton ("Cancel", this);
    cancel->setGeometry (30, 100, 90, 25);

    connect (ok, SIGNAL (clicked()), SLOT (accept()));
    connect (cancel, SIGNAL (clicked ()), SLOT (reject()));
    connect (columnTitle, SIGNAL (returnPressed ()), SLOT (accept ()));

    columnTitle->setFocus ();
  }


columnTitleWidget::~columnTitleWidget ()
  {
    delete ok;
    delete cancel;
    delete columnTitle;
  }


char* columnTitleWidget::getLineEditStr ()
  {
    static char name[255];
    strcpy (name, columnTitle->text());

    return (name);
  }

