#ifndef _TREE_H_
#define _TREE_H_

#include <kmenubar.h>
#include <ktoolbar.h>
#include <ktreelist.h>
#include <kstatusbar.h>
#include <ktopwidget.h>

#include <qwidget.h>
#include <qpopmenu.h>
#include <qkeycode.h>
#include <qfiledlg.h>
#include <qpixmap.h>
#include <qmsgbox.h>


class Page;
class PageObject;
class Plot;
class Worksheet;


/** Tree items for the Korigin Main Tree.


	In addition to an "ordinary" KTreeListItem, this class also
	includes a pointer to the associated QObject. This may be one
	of the following: Page, PageObject heir (Plot etc), Worksheet.

	@see #Tree
	@author Patrick Schemitz
*/
class TreeItem : public KTreeListItem
{
public:

  /// Build tree item.
  TreeItem (const char *theText = 0, const QPixmap *thePixmap = 0);

  /** Destroy tree item.

	  Does not destroy the object! The object is destroyed from its
	  creator, the centre class.
  */
  ~TreeItem ();

  /// Get the object pointer.
  QObject* object () { return the_object; }

  /// Set the object pointer.
  void setObject (QObject* o) { the_object=o; }

private:

  /// Object pointer storage.
  QObject* the_object;
};



/** Korigin Main Tree.


	This is a subclass from KTreeList, with a popup menu on right
	mouse button, to remove list entries. The tree consists of
	TreeItems.

	@see #KTreeList
	@see #TreeItem
	@author Patrick Schemitz
*/
class Tree : public KTreeList
{
  Q_OBJECT

public:

  /// Build a main tree.
  Tree (QWidget* parent = 0, const char* name = 0, WFlags f = 0);
  /// Destroy the main tree, delete the items and thus the objects.
  ~Tree ();

public slots:

  /// Activated when the active page changed.
  void pageChanged (Page*);

  /// Activated when the active plot changed.
  void plotChanged (Plot*);

  /// Activated when the active worksheet changed.
  void worksheetChanged (Worksheet*);

signals:

  /// Emitted when the active page has changed.
  void pageHasChanged (Page*);

  /// Emitted when the active plot has changed.
  void plotHasChanged (Plot*);

  /// Emitted when the active worksheet has changed.
  void worksheetHasChanged (Worksheet*);

  /// Emitted when a page has to be deleted.
  void removePage (Page*);

  /// Emitted when a page object has to be deleted.
  void removePageObject (PageObject*);

  /// Emitted when a worksheet has to be deleted.
  void removeWorksheet (Worksheet*);

private:

  /// Implements the right mouse button menu.
  void mousePressEvent (QMouseEvent*);

  /// Holds the right mouse button menu.
  QPopupMenu* tree_menu;

private slots:

  /// Slot for the right button menu to delete the current item.
  void deleteCurrentItem ();
};

#endif
