//
// Copyright (C) 1999, Mark W J Redding <grawlfang@tesco.net>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include "mapView.h"
#include "Konstellation.h"

extern "C"
{
#include "Stars.h"
}

mapView::mapView(QWidget* p, double s, double m, const char* n)
	: QWidget(p,n)
{
	m_scale=s;
	m_mag=m;
	m_parent=(Konstellation*)p;
	setBackgroundColor(black);
}

mapView::~mapView()
{
}

void
mapView::resizeEvent(QResizeEvent* e)
{
	int aw = width();
	int ah = height();
}

void
mapView::mousePressEvent(QMouseEvent* e)
{
	double x=(double)(e->x()-7)/m_scale;
	double y=(double)(e->y()-7)/m_scale;
	x=(360.0-x)/15.0;
	if(y>90.0)
		y=0.0-(y-90.0);
	else
		y=90.0-y;

	if(e->button()==MidButton) m_parent->centre(e->x(),e->y());
	if(e->button()==LeftButton) m_parent->locate(x,y);
	if(e->button()==RightButton) m_parent->showStar(getStar(x,y),e->globalX(),e->globalY());
}

void
mapView::paintEvent(QPaintEvent*)
{
QPainter paint;

	paint.begin(this);
	drawMap(paint);
	paint.end();
}

double
mapView::getScale()
{
	return m_scale;
}

void
mapView::setScale(double s)
{
	m_scale=s;
	resize((int)(360.0*s+15),(int)(180.0*s+15));
}

double
mapView::getMagnitude()
{
	return m_mag;
}

void
mapView::setMagnitude(double m)
{
	m_mag=m;
	repaint();
}

long
mapView::getStar(double ra, double dec)
{
int sts,fetch;
long rs=0;

	for(double r=0.1;r<1.0;r+=0.1)
	{
		sts=::OpenFind(ra,dec,m_mag,r);
		fetch=::FetchFind();
		if(!fetch) break;
		sts=::CloseFind();
	}
	if(!fetch) rs=getBSCatalog();

	return(rs);
}

void
mapView::OutlineConstellations(QPainter& p)
{
int sts;
double fra,tra,fdec,tdec;

	p.setPen(lightGray);
	sts=::OpenOutlines();
	for(;;)
	{
		sts=::FetchOutlines(&fra,&fdec,&tra,&tdec);
		if(sts) break;
		p.drawLine(RAtoINT(fra),DECtoINT(fdec),RAtoINT(tra),DECtoINT(tdec));
	}
	sts=::CloseOutlines();

}

int
mapView::RAtoINT(double ra, int sub)
{
	ra=(360.0-ra)*m_scale;
	int ira = 7+(int)ra-sub;
	return ira;
}

int
mapView::DECtoINT(double dec, int sub)
{
	if(dec<0.0)
		dec=90.0+abs((int)dec);
	else
		dec=90.0-dec;
	dec=dec*m_scale;
	int idec=7+(int)dec-sub;
	return idec;
}


