/***************************************************************************
                          bnachbar.cpp  -  description
                             -------------------
    begin                : Thu Jan 6 2000
    copyright            : (C) 2000 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qprogressbar.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include <math.h>
#include <stdlib.h>
#include <iostream.h>

#include "bnachbar.h"
#include "bhebbuch.h"
#include "bhebidx.h"
#include "bitana.h"

#define ANZELS 35
#define MAXELS 25.0
#define ANZGRP 20
#define STRSEP "\t"
#define ANZZL 34
#define ZLBRT 52

BNachbar::BNachbar()
{
 heb=new BHebBuch();
}
BNachbar::~BNachbar()
{
 delete heb;
}

bool BNachbar::suchNachbar(QString buch, QString *wrtsp, int vpos, int bpos)
{
 struct STREIN
 {
  int  apos;                          // Startposition ELS
  int  epos;                          // Endposition ELS
  int  inter;                         // Sequenz ELS
  int  richt;                         // Route ELS
 };

 union UNIEIN
 {
  STREIN sein;
  char   cein[sizeof(STREIN)];
 };

  extern BitanaApp *bitana;

 _stop = false;

 connect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));

// Delete old version the outputfile
 QFile a1;
 QDir d=QDir::root();
 if(d.cd(bitana->getTmpDir())) a1.setName(d.filePath("nrb1.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the workong directory\n")+bitana->getTmpDir());
  return false;
 }
 a1.remove();
 a1.setName(d.filePath("nrb2.lst"));
 a1.remove();
 a1.setName(d.filePath("nrb3.lst"));
 a1.remove();

// Check the input data
 uint datlng=heb->lngBuch(buch);
 bool ok=heb->modifiText(buch);
 if(!ok) return FALSE;
 if(datlng==0) return FALSE;
 if(datlng<(uint)bpos) bpos=datlng;
 if(vpos>bpos)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have given wrong (or to short) search length."));
   return FALSE;
 }

// Set up words data
 int lw=0;
 for(lw=0;lw<5;lw++) if(wrtsp[lw]=="") break;
 int anzwrt=lw;
 int anz[5];
 for(lw=0;lw<5;lw++) anz[lw]=0;

// Prepare interfile
 QFile  e1;
 d=QDir::root();
 if (d.cd(bitana->getTmpDir())) e1.setName(d.filePath("ilst.zwi"));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the directory")+bitana->getTmpDir());
  return false;
 }

// ELS search for all words
 struct STRMEM
 {
  int  apos;                          // Startposition ELS
  int  epos;                          // Endposition ELS
  int  inter;                         // Sequenz ELS
  int  richt;                         // Route ELS
  int  aber;                          // Begin range minimal
  int  eber;                          // End range minimal
  int  proz;                          // Persent range minimal
  int  tmp;                           // Workfield
  int  entf[5];                       // Distance to ELS
  int  satz[5];                       // Number of ELS
 };

 QString datnam;
 QString tmp;
 int maxint=0;
 float erw=0.0;
 float zwrt=MAXELS/(anzwrt-1);
 int ls,zw;
 int i,j;
 UNIEIN ein;
 STRMEM fld[5][ANZELS];

 for(lw=0;lw<anzwrt;lw++)
 {

// Calculate maxint for search ELS
  heb->modifiWort(wrtsp[lw]);
  erw=0.0;

  maxint=1;
  while(erw<zwrt)
  {
   if(maxint<10)  maxint++;
   else if(maxint<100) maxint+=10;
        else if(maxint<1000) maxint+=100;
             else maxint+=1000;

   erw=heb->intervallErwart(buch,wrtsp[lw],vpos,bpos,2,maxint,0);
   if(maxint>((bpos-vpos)/(int)(wrtsp[lw].length()-1))) break;
  }
  anz[lw]=heb->listeIntervall(buch,wrtsp[lw],vpos,bpos,2,maxint,0,"ilst.zwi");
  if(anz[lw]<0 || _stop) return false;

// Control ELS
  if(anz[lw]==0)
  {
   tmp=i18n("For word ");
   tmp+=wrtsp[lw];
   tmp+=i18n("\n no ELS find");
   QMessageBox::warning(0,i18n("Error"),
                         tmp);
   return false;
  }

// Set up sort ELS
  if (!e1.open(IO_ReadOnly))
  {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot find the tempfile \n ilst.zwi"));
   return false;
  }

  for(ls=0;ls<ANZELS;ls++)
  {
   fld[lw][ls].apos=999999;
   fld[lw][ls].epos=0;
   fld[lw][ls].inter=999999;
   fld[lw][ls].richt=0;
   fld[lw][ls].aber=0;
   fld[lw][ls].eber=bpos;
   fld[lw][ls].proz=0;
   fld[lw][ls].tmp=0;
  }

// Sort to ELS
  e1.at(0);
  while(!e1.atEnd())
  {
   e1.readBlock(ein.cein,sizeof(STREIN));
   if(ein.sein.apos>ein.sein.epos)
   {
    zw=ein.sein.apos;
    ein.sein.apos=ein.sein.epos;
    ein.sein.epos=zw;
   }
   ls=0;
   while(ein.sein.inter>=fld[lw][ls].inter && ls<ANZELS) ls++;
   while(ein.sein.inter==fld[lw][ls].inter
      && ein.sein.apos>=fld[lw][ls].apos && ls<ANZELS) ls++;

   if(ls<ANZELS)
   {
    for(j=ANZELS-1;j>ls;j--) fld[lw][j]=fld[lw][j-1];
    fld[lw][ls].inter=ein.sein.inter;
    fld[lw][ls].apos=ein.sein.apos;
    fld[lw][ls].epos=ein.sein.epos;
    fld[lw][ls].richt=ein.sein.richt;
   }
   if(_stop) return false;
  }
  e1.close();
 } // End sort lw

// Designate minimal range for ELS
 for(lw=0;lw<anzwrt;lw++)
 {
  ls=0;
  while(ls<ANZELS)
  {
   if(fld[lw][ls].inter==999999) break;
   j=0;
   while(j<ANZELS)
   {
    if(ls!=j)
    {
     if(fld[lw][ls].inter<=fld[lw][j].inter || fld[lw][ls].eber==0) break;

// Down range limit
     if(fld[lw][ls].apos>=fld[lw][j].epos &&
        fld[lw][ls].aber<fld[lw][j].epos) fld[lw][ls].aber=fld[lw][j].epos+1;

// Up range limit
     if(fld[lw][ls].epos<=fld[lw][j].apos   &&
        fld[lw][ls].eber>fld[lw][j].apos) fld[lw][ls].eber=fld[lw][j].apos-1;

// In rage limit
     if(fld[lw][ls].aber<=fld[lw][j].apos &&
        fld[lw][ls].eber>=fld[lw][j].epos)
     {
      fld[lw][ls].aber=fld[lw][j].apos;
      fld[lw][ls].eber=fld[lw][j].epos;
      if(fld[lw][ls].aber>fld[lw][ls].apos || fld[lw][ls].eber<fld[lw][ls].epos)
      {
       fld[lw][ls].aber=0;
       fld[lw][ls].eber=0;
      }
      break;
     }
    }
    j++;
   }
   fld[lw][ls].proz=((fld[lw][ls].eber-fld[lw][ls].aber)*100)/(bpos-vpos);
   ls++;
  }
 }

// Begin distance designate
 int refe=0;

 for(lw=0;lw<anzwrt;lw++)
 {
  for(ls=0;ls<ANZELS;ls++)
  {
   if(fld[lw][ls].inter==999999) break;
   fld[lw][ls].satz[lw]=ls;

// Calculate minimal liniar distance for neigthbour words
   for(i=0;i<anzwrt;i++) fld[lw][ls].entf[i]=999999;
   for(i=0;i<anzwrt;i++) if(i!=lw) for(j=0;j<ANZELS;j++)
   {
    if(fld[i][j].inter==999999) break;
    fld[i][j].tmp=999999;
    refe=abs(fld[lw][ls].apos-fld[i][j].apos);
    if(fld[i][j].tmp>refe) fld[i][j].tmp=refe;
    refe=abs(fld[lw][ls].epos-fld[i][j].epos);
    if(fld[i][j].tmp>refe) fld[i][j].tmp=refe;
    refe=abs(fld[lw][ls].apos-fld[i][j].epos);
    if(fld[i][j].tmp>refe) fld[i][j].tmp=refe;
    refe=abs(fld[lw][ls].epos-fld[i][j].apos);
    if(fld[i][j].tmp>refe) fld[i][j].tmp=refe;
    if(fld[lw][ls].entf[i]>fld[i][j].tmp)
    {
     fld[lw][ls].entf[i]=fld[i][j].tmp;
     fld[lw][ls].satz[i]=j;
    }
   }
  }
 }

// Designate 20 groups to continue calculate
 struct STRGRP
 {
  int   entf;                          // Linear distance inter ELS
  int   seq;                           // ELS for minimal distance
  int   proz;                          // Precent domain
  int   adom;                          // Startposition minimal domain
  int   edom;                          // Endposition minimal domain
  float abst;                          // Euklid minial distance
  float koab;                          // Modify Euklid minimal distance
  int   els[5];                        // Number of ELS for group
 };
 STRGRP grp[ANZGRP];
 int lg;

// Initial group member
 for(lg=0;lg<ANZGRP;lg++)
 {
  grp[lg].entf=999999;
  grp[lg].seq=0;
  grp[lg].abst=0.0;
  grp[lg].koab=0.0;
  grp[lg].proz=0;
  for(j=0;j<5;j++) grp[lg].els[j]=0;
 }

// Sumary the linear distance to all ELS
 for(lw=0;lw<anzwrt;lw++) for(ls=0;ls<ANZELS;ls++)
 {
  if(fld[lw][ls].inter==999999) break;
  refe=0;
  for(i=0;i<anzwrt;i++) if(fld[lw][ls].entf[i]<999999) refe+=fld[lw][ls].entf[i];

// Sort in the select group
  lg=0;
  while(grp[lg].entf<=refe && lg<ANZGRP) lg++;

  if(lg<ANZGRP)
  {
   for(j=ANZGRP-1;j>lg;j--) grp[j]=grp[j-1];
   grp[lg].entf=refe;
   for(j=0;j<anzwrt;j++) grp[lg].els[j]=fld[lw][ls].satz[j];

// Search equality group and eliminiere this group
   for(j=0;j<ANZGRP;j++)
   {
    if(grp[j].entf==999999) break;
    if(j!=lg)
    {
     i=0;
     while(i<anzwrt && grp[lg].els[i]==grp[j].els[i] && grp[j].entf<999999) i++;
     if(i==anzwrt)
     {
      if(lg<j) i=j;
      else    i=lg;
      for(j=i;j<ANZGRP-1;j++) grp[j]=grp[j+1];
      grp[ANZGRP-1].entf=999999;
     }
    }
   }
  }
 }

// Calculate the minimal domain and the Euklid minimal distance for group's
 for(lg=0;lg<ANZGRP;lg++)
 {
  for(i=0;i<anzwrt;i++)
  {
   aber[i]=fld[i][grp[lg].els[i]].aber;
   eber[i]=fld[i][grp[lg].els[i]].eber;
   apos[i]=fld[i][grp[lg].els[i]].apos;
   epos[i]=fld[i][grp[lg].els[i]].epos;
   inter[i]=fld[i][grp[lg].els[i]].inter;
   prozi[i]=fld[i][grp[lg].els[i]].proz;
  }
  abstand(anzwrt,(bpos-vpos));
  grp[lg].proz=proz;
  grp[lg].abst=abst;
  grp[lg].seq=seq;
  grp[lg].koab=1/abst;
  grp[lg].adom=adom;
  grp[lg].edom=edom;
  if(proz!=0) grp[lg].koab*=proz;
 }

// Sort group's to distance
 STRGRP zwi;

 float sum=0.0;
 for(lg=1;lg<ANZGRP;lg++)
 {
  sum+=grp[lg].koab;
  for(i=0;i<lg;i++)
  {
   if(grp[lg].koab>grp[i].koab)
   {
    zwi=grp[lg];
    grp[lg]=grp[i];
    grp[i]=zwi;
   }
  }
 }
 sum/=ANZGRP;   // Calculate medial value

// Open the files 'nbr1.lst' to write max range off ELS
 QFile a2;
 a2.setName(d.filePath("nbr1.lst"));
 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a2.name());
 }

// Create head of neigthbour list for group's
 QTextStream tab(&a2);
 QString     lste;

 tab<<"# Tabelle"<<endl;
 tab<<"# \t";
 tmp.setNum(anzwrt+6);
 tab<<tmp;
 tab<<i18n("\tGroup\t40\tCompact\t100\tLinelength\t65\tRangebegin\t80\tRangeaend\t80\tPercent\t60");
 for(i=0;i<anzwrt;i++) tab<<"\tSequenz\t60";
 tab<<"\t"<<endl;
 tab<<i18n("# Table of neigthbour compact's for ELS to ");
 for(i=0;i<anzwrt;i++) tab<<wrtsp[i]<<", ";
 tab<<"in "<<buch.upper()<<endl;

// Make the list
 for(j=0;j<ANZGRP;j++)
 {
  if(grp[j].entf==999999) break;
  tmp.setNum(j+1);
  lste=tmp+SEP;
  tmp.setNum(grp[j].koab);
  lste+=tmp+SEP;
  tmp.setNum(grp[j].seq);
  lste+=tmp+SEP;
  tmp.setNum(grp[j].adom);
  lste+=tmp+SEP;
  tmp.setNum(grp[j].edom);
  lste+=tmp+SEP;
  tmp.setNum(grp[j].proz);
  lste+=tmp+SEP;
  for(i=0;i<anzwrt;i++)
  {
   tmp.setNum(fld[i][grp[j].els[i]].inter);
   lste+=tmp+SEP;
  }
  tab<<lste<<endl;
 }
 a2.close();

// Open the files 'nbr2.lst' to write max range off ELS
 a2.setName(d.filePath("nbr2.lst"));
 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a2.name());
 }

// Create head of ELS neigthbour list for group's
 QTextStream lst(&a2);

 lst<<"# Tabelle"<<endl;
 lst<<i18n("# \t8\tGroup\t40\tLinelength\t65\tSequenz\t55\tStartpos\t60\tEndpos\t60");
 lst<<i18n("\tRangebegin\t80\tRangeend\t80\tPercent\t60\t")<<endl;;
 lst<<i18n("# Table of ELS for neigthbour groups to ");
 for(i=0;i<anzwrt;i++) lst<<wrtsp[i]<<", ";
 lst<<"in "<<buch.upper()<<endl;

// Make the list
 for(j=0;j<ANZGRP;j++)
 {
  if(grp[j].entf==999999) break;
  tmp.setNum(j+1);
  lste=tmp+SEP;
  tmp.setNum(grp[j].seq);
  lste+=tmp+SEP;
  lst<<lste<<" "<<STRSEP<<" "<<STRSEP<<" "<<STRSEP;
  tmp.setNum(grp[j].adom);
  lste=tmp+SEP;
  tmp.setNum(grp[j].edom);
  lste+=tmp+SEP;
  tmp.setNum(grp[j].proz);
  lste+=tmp+SEP;
  lst<<lste<<endl;
  for(i=0;i<anzwrt;i++)
  {
   lst<<" "<<STRSEP<<" "<<STRSEP;
   tmp.setNum(fld[i][grp[j].els[i]].inter);
   lste=tmp+SEP;
   tmp.setNum(fld[i][grp[j].els[i]].apos);
   lste+=tmp+SEP;
   tmp.setNum(fld[i][grp[j].els[i]].epos);
   lste+=tmp+SEP;
   tmp.setNum(fld[i][grp[j].els[i]].aber);
   lste+=tmp+SEP;
   tmp.setNum(fld[i][grp[j].els[i]].eber);
   lste+=tmp+SEP;
   tmp.setNum(fld[i][grp[j].els[i]].proz);
   lste+=tmp+SEP;
   lst<<lste<<endl;
  }
 }
 a2.close();

// Begin matrix list 'abb3.lst'
 for(i=0;i<anzwrt;i++)
 {
  aber[i]=fld[i][grp[0].els[i]].aber;
  eber[i]=fld[i][grp[0].els[i]].eber;
  apos[i]=fld[i][grp[0].els[i]].apos;
  epos[i]=fld[i][grp[0].els[i]].epos;
  inter[i]=fld[i][grp[0].els[i]].inter;
 }
 seq=grp[0].seq;

// Designate begin and endpos of picture
 int beg=999999;
 int end=0;
 div_t dp1,dp2;

 for(i=0;i<anzwrt;i++)
 {
  if(beg>apos[i]) beg=apos[i];
  if(end<epos[i]) end=epos[i];
 }

// Calculate perspective plane
 int  hoe,brt;
 int bra,bre;
 int zwpos;
 int spd[3];

// Check equality line distanze
 spd[0]=0;
 spd[1]=999999;
 spd[2]=0;
 while(spd[0]<seq)
 {
  beg--;
  if(beg<0) break;
  j=0;
  brt=0;
  hoe=beg;
  while(j<anzwrt)
  {
   ok=true;
   bre=(int)wrtsp[j].length()-1;
   while(ok)
   {
    ok=false;
    bra=apos[j]-beg;
    dp1=div(bra,seq);
    dp2=div((bra+inter[j]),seq);
    if(brt<dp2.rem) brt=dp2.rem;
    zwpos=dp2.quot-dp1.quot;
    i=1;
    while(i<bre)
    {
     bra+=inter[j];
     dp1=div(bra,seq);
     dp2=div((bra+inter[j]),seq);
     if(brt<dp2.rem) brt=dp2.rem;
     if(zwpos!=(dp2.quot-dp1.quot))
     {
      beg--;
      if((beg-hoe)>=seq) break;
      ok=true;
      j=0;
      break;
     }
     i++;
    }
   }
   j++;
  }
  if(spd[1]>brt)
  {
   spd[1]=brt;
   spd[2]=beg;
  }
  spd[0]++;
 }
 beg=spd[2];
 brt=spd[1];

// Calculate higth
 dp1=div(beg,seq);
 dp2=div(end,seq);
 hoe=abs(dp1.quot-dp2.quot)+1;   // Higth picture

// Calculate begin and end perspective plane
 if(hoe<ANZZL-1) bra=(ANZZL-hoe)/2;
 else bra=0;
 bre=bra;
 while(bra>0)
 {
  beg-=seq;
  if(beg<0) beg+=seq;
  bra--;
 }
 if(seq>ZLBRT && brt<ZLBRT) beg-=(ZLBRT-brt)/2;
 if(beg<0) beg=0;
 end=((hoe+(2*bre))*seq)+beg;
 if(brt>ZLBRT) bra=brt;
 else if(seq<=ZLBRT) bra=seq;
      else bra=ZLBRT;

 while((uint)end>datlng) end=datlng;

 a2.setName(d.filePath("nbr3.lst"));
 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a2.name());
 }

// Create head of ELS neigthbour picture for groups
 QTextStream mat(&a2);
 QString tabstr;
 idx=new BHebIdx();

 mat<<"# Matrix"<<endl;
 dp1=div((end-beg),seq);
 mat<<"# "<<bra<<SEP<<dp1.quot<<endl;
 tmp=buch.upper();
 tab<<i18n("# Picture of neigthbour compact for ELS to ");
 for(i=0;i<anzwrt;i++) mat<<wrtsp[i]<<", ";
 mat<<"in "<<buch.upper()<<endl;
 tabstr=i18n("# Textshowing with line length ");
 tmp.setNum(seq);
 tabstr+=tmp;
 tabstr+=i18n(" by presentation of ");
 tmp.setNum(bra);
 mat<<tabstr<<tmp<<endl;
 tabstr=i18n("# From position ");
 tmp.setNum(beg);
 mat<<tabstr<<tmp<<" (";
 idx->posKap(buch, beg);
 tmp=idx->versdat.kapvers;
 mat<<tmp.left(6)<<")";
 tabstr=i18n(" to position ");
 tmp.setNum(end);
 mat<<tabstr<<tmp<<" (";
 idx->posKap(buch, end);
 tmp=idx->versdat.kapvers;
 tmp+=")";
 mat<<tmp.left(6)<<")"<<endl;

// Create perspective plane
 int aktpos[5];
 int f;
 zwpos=beg;
 for(i=0;i<5;i++) aktpos[i]=0;
 for(i=0;i<anzwrt;i++) aktpos[i]=apos[i];    // Position for color

 while(beg<end)
 {
  j=0;
  tabstr="";
  while(j<bra)
  {
   f=0;
   for(i=0;i<anzwrt;i++)
   {
    if(aktpos[i]==beg)
    {
     f=i+3;
     if(aktpos[i]<epos[i]) aktpos[i]+=inter[i];
    }
   }
   tabstr.insert(0,heb->lesBuchst(buch,beg));
   if(f>0)
   {
    tmp.setNum(f);
    tabstr.insert(0,("\t"+tmp));
   }
   j++;
   beg++;
   if(beg>(int)datlng) break;
  }
  mat<<tabstr;
  beg=zwpos+seq;
  if(beg>(int)datlng) break;
  zwpos=beg;
 }
 a2.close();
 return TRUE;
}


void BNachbar::abstand(int aw, int lng)
{
 int ls;
 int i,j,y;
 float refe,refe2;

// Minimal domain
 proz=0;
 adom=0;
 edom=999999;

// Minimal domain
 for(i=0;i<aw;i++)
 {
  if(eber[i]!=0)
  {
   if(aber[i]>adom) adom=aber[i];
   if(eber[i]<edom) edom=eber[i];
  }
  else
  {
   adom=edom=0;
   break;
  }
 }
 if(edom!=0) for(i=0;i<aw;i++) if(apos[i]<adom || apos[i]>edom
                               || epos[i]<adom || epos[i]>edom) adom=edom=0;

 if(adom<edom) proz=((edom-adom)*100)/lng;
 else adom=edom=0;

// Minimal distace
 abst=999999.0;
 seq=0;

 for(i=0;i<aw;i++)
 {
  if(abst==0) break;
  for(y=1;y<8;y++)
  {
   refe=0.0;
   refe2=0.0;
   for(j=0;j<aw;j++)
   {
    ls=inter[i]*y;
    if(i!=j)
    {
     refe=wurzel(apos[i],epos[j],ls);
     refe2=wurzel(epos[i],apos[j],ls);
     if(refe>refe2) refe=refe2;
     refe2=wurzel(apos[i],apos[j],ls);
     if(refe>refe2) refe=refe2;
     refe2=wurzel(epos[i],epos[j],ls);
     if(refe>refe2) refe=refe2;
     refe+=wurzel(apos[i],apos[i]+inter[i],ls);
     refe+=wurzel(apos[j],apos[j]+inter[j],ls);
    }
   }
   if(refe<abst)
   {
    abst=refe;
    seq=ls;
   }
   if(y>1)
   {
    refe=0.0;
    for(j=0;j<aw;j++)
    {
     ls=inter[i]/y;
     if(ls<4) break;
     if(i!=j)
     {
      refe=wurzel(apos[i],epos[j],ls);
      refe2=wurzel(epos[i],apos[j],ls);
      if(refe>refe2) refe=refe2;
      refe2=wurzel(apos[i],apos[j],ls);
      if(refe>refe2) refe=refe2;
      refe2=wurzel(epos[i],epos[j],ls);
      if(refe>refe2) refe=refe2;
      refe+=wurzel(apos[i],apos[i]+inter[i],ls);
      refe+=wurzel(apos[j],apos[j]+inter[j],ls);
     }
    }
    if(refe<abst && ls>3)
    {
     abst=refe;
     seq=ls;
    }
   }
  }
 }
}

float BNachbar::wurzel(int p1, int p2, int s)
{
 float wur;
 div_t dp1,dp2;

 dp1=div(p1,s);
 dp2=div(p2,s);
 dp1.quot=abs(dp1.quot-dp2.quot);
 dp1.rem=abs(dp1.rem-dp2.rem);

 if(dp1.rem!=0 && dp1.quot!=0) wur=hypot((double)dp1.rem,(double)dp1.quot);
 if(dp1.rem==0) wur=(float)dp1.quot;
 if(dp1.quot==0) wur=(float)dp1.rem;
 return wur;
}

void BNachbar::slotStop()
{
  _stop = true;
}







































