
/***************************************************************************
                          blexpar.cpp  -  description
                             -------------------
    begin                : Sun Mar 26 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qbttngrp.h>
#include <qpushbt.h>

// include files for KDE
#include <ktabctl.h>

#include "bhebinp.h"
#include "bibview.h"
#include "blexpar.h"
#include "resource.h"
#include "blexikon.h"
#include "iostream.h"


BLexPar::BLexPar(QWidget *parent, const char *name ) : QWidget(parent,name)
{

   	extern BitanaApp *bitana;
		QFont hebfont(bitana->getHebFont1());

// Gruppe Suchwort

  QButtonGroup* intw;
  intw = new QButtonGroup( this, "intw" );
  intw->setGeometry( 0, 5, 260, 90 );
  intw->setFrameStyle( 49 );
  intw->setTitle( i18n("searchword:" ));
	
  QPushButton *but;
	
	but  = new QPushButton(this, "w");
	but->setGeometry( 5, 25, 40, 30 );
	but->setText( "W>" );
	intw->insert(but);
	
  iwort = new QLabel(this, "iw");
  iwort->setGeometry( 50, 25, 200, 30 );
	iwort->setFont( hebfont );
	iwort->setFrameStyle( 49 );
	iwort->setText("");

 	connect(intw, SIGNAL(clicked(int)), this, SLOT(slotPressW(int)));

	ana = new QCheckBox(i18n("with privat dictionary"), this, "ana");
  ana->setGeometry(10, 60, 200, 30);

}

BLexPar::~BLexPar()
{
}

/** Wort Button gedrckt */
void BLexPar::slotPressW(int x)
{

  KTabCtl* tab = (KTabCtl*)parentWidget();
	BibView* v   = (BibView*)tab->parentWidget();
	BHebInp* i = v->inp;
	iwort->setText( (i->readInput()).rightJustify(16, ' '));
	
	
	BLexikon *lex =new BLexikon();
	lex->listWort(i->readInput());
  delete lex;
  v->markFileItem("lex1.lst");
}