/***************************************************************************
                          bintervall.cpp  -  description
                             -------------------
    begin                : Wed Dec 1 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "bintervall.h"
#include "bhebbuch.h"
#include "bhebidx.h"
#include "bitana.h"

BIntervall::BIntervall()
{
 heb=new BHebBuch();
 idx=new BHebIdx();
}

BIntervall::~BIntervall()
{
 delete heb;
 delete idx;
}

bool BIntervall::suchIntervall(QString buch, QString wort,
                               int vpos, int bpos,
                               int vint, int bint,
                               int richt, bool sor)
{
  struct STREIN
  {
   int  apos;                          // Startposition ELS
   int  epos;                          // Endposition ELS
   int  inter;                         // Sequenz ELS
   int  richt;                         // Route ELS
  };

  union UNIEIN
  {
   STREIN sein;
   char   cein[sizeof(STREIN)];
  };

// Create the output file and delete the old version
 extern BitanaApp *bitana;

 QFile a1;
 QDir d=QDir::root();
 if(d.cd(bitana->getTmpDir())) a1.setName(d.filePath("int1.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the working directory\n")+bitana->getTmpDir());
  return false;
 }
 a1.remove();

 int lng=wort.length();
 int suchlng=bpos-vpos;
 if(lng<3)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have not given (or to short) input word."));
   return false;
 }
 if((suchlng+1)<lng)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have not given (or to short) search length"));
   return false;
 }

// Control data length with search length
 uint datlng=heb->lngBuch(buch);
 if(datlng==0) return FALSE;
 if(datlng<(uint)bpos)
 {
  switch (QMessageBox::information(0,i18n("Warning: Datasection searchtext"),
                          i18n("Datasection to long\nsetting of correct length???"),
                          i18n("&Yes"),i18n("&No=Cancel"), 0, 1))
   {
    case 0:
      bpos=datlng-1;
      break;
    case 1: return FALSE;
   }
 }

 heb->modifiWort(wort);
 wort=heb->textUmkehr(wort);
 bool ok=heb->modifiText(buch);
 if(!ok) return FALSE;

// Control and modify max ELS
 if(bint>(suchlng/(lng-1))) bint=(suchlng/(lng-1));

// Filename for ELS buffer
 QString zwnam="ilst.zwi";

// ELS pending and direct
 float erwart=heb->intervallErwart(buch,wort,vpos,bpos,vint,bint,richt);
 int anz=heb->listeIntervall(buch,wort,vpos,bpos,vint,bint,richt,zwnam);
 if(anz<0) return false;
 if(anz==0)
 {
  QString tmp=i18n("For word ");
  tmp+=wort;
  tmp+=i18n("\n no ELS find");
  QMessageBox::warning(0,i18n("Abbort"),
                         tmp);
   return false;
  }

// Create inputfile ELS
 UNIEIN ein;
 QFile  e1;
 d=QDir::root();

 if (d.cd(bitana->getTmpDir())) e1.setName(d.filePath(zwnam));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the working directory")+bitana->getTmpDir());
  return FALSE;
 }

 if (!e1.open(IO_ReadOnly))
 {
  QMessageBox::warning(0,i18n("Cannot find the file"),
                         i18n("Tempfile ")+zwnam);
  return false;
 }

 STREIN *srt;
 int l,j;
 int a=0;
 int zw=0;

 srt=new STREIN[anz];

 for(l=0;l<anz;l++)
 {
  srt[l].inter=999999;
  srt[l].apos=999999;
  srt[l].epos=999999;
  srt[l].richt=0;
 }

// Sort ELS
 e1.at(0);
 a=0;
 while(!e1.atEnd())
 {
  e1.readBlock(ein.cein,sizeof(STREIN));
  if(ein.sein.apos>ein.sein.epos)
  {
   zw=ein.sein.apos;
   ein.sein.apos=ein.sein.epos;
   ein.sein.epos=zw;
  }
  l=0;
  if(sor)  // to apos
  {
   while(ein.sein.apos>=srt[l].apos   && l<a) l++;
   while(ein.sein.apos==srt[l].apos   &&
         ein.sein.inter>=srt[l].inter && l<a) l++;
  }
  else   // to seqenz
  {
   while(ein.sein.inter>=srt[l].inter && l<a) l++;
   while(ein.sein.inter==srt[l].inter &&
         ein.sein.apos>=srt[l].apos   && l<a) l++;
  }

  if(l<anz)
  {
   for(j=a;j>l;j--) srt[j]=srt[j-1];
   a++;
   srt[l].inter=ein.sein.inter;
   srt[l].apos=ein.sein.apos;
   srt[l].epos=ein.sein.epos;
   srt[l].richt=ein.sein.richt;
  }
 }
 e1.close();

 // Open the files 'int1.lst' to write ELS
 if (!a1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a1.name());
 }

 QTextStream lst(&a1);
 QString lste;
 QString tmp;

// Create listhead
 lst<<"# Tabelle"<<endl;
 lst<<i18n("# \t4\tStartpos\t80\tEndpos\t80\tSequenz\t60\tRoute\t20")<<endl;
 lst<<i18n("# List of ELS to ")<<heb->textUmkehr(wort)<<" in "<<buch.upper();
 tmp.setNum(vpos);
 lst<<i18n(" from position ")<<tmp<<"(";
 idx->posKap(buch, vpos);
 tmp=idx->versdat.kapvers;
 lst<<tmp.left(6)<<")";
 tmp.setNum(bpos);
 lst<<i18n(" to position ")<<tmp<<"(";
 idx->posKap(buch, bpos);
 tmp=idx->versdat.kapvers;
 tmp+=")";
 lst<<tmp.left(6)<<")"<<endl;
 lst<<i18n("# Statistic expection ")<<erwart<<i18n(" and find ")<<anz<<endl;

// Read ELS sort range and write ELS list
 l=0;
 while(l<anz)
 {
  tmp.setNum(srt[l].apos);
  lste=tmp+SEP;
  tmp.setNum(srt[l].epos);
  lste+=tmp+SEP;
  tmp.setNum(srt[l].inter);
  lste+=tmp+SEP;
  if(srt[l].richt) lste+="R";
  else lste+="V";
  lst<<lste<<endl;
  l++;
 }
 a1.close();
 delete srt;
 return TRUE;
}





















