/***************************************************************************
                          bibtext.cpp  -  description
                             -------------------
    begin                : Thu Dec 30 1999
    copyright            : (C) 1999 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/



// include files for QT
#include <qdir.h>
#include <qfileinf.h>
#include <qmessagebox.h>
#include <qfiledialog.h>

// include files for KDE
#include <kapp.h>
#include <klocale.h>

// application specific includes
#include "bibtext.h"
#include "bhebidx.h"
#include "resource.h"

#define CVSEP 	':'       // Capital - Vers Separator
#define CVSTS 	":"       // ... String Separator


BibText::BibText(QWidget *parent) {

pvalid = new QIntValidator(this);
//pvalid->setRange(1, 100);

}

void BibText::initBar(KToolBar *bookbar) {


	buch = bookbar->getCombo(ID_BOOK_CHOICE);

	kvon = bookbar->getLined(ID_BOOK_KVON);
	kbis = bookbar->getLined(ID_BOOK_KBIS);
	
	QButton *p2k = bookbar->getButton(ID_BOOK_P2K);
	QButton *k2p = bookbar->getButton(ID_BOOK_K2P);


	pvon = bookbar->getLined(ID_BOOK_PVON);
	pbis = bookbar->getLined(ID_BOOK_PBIS);

	connect(buch, SIGNAL(activated(int)), SLOT(slotBookChanged(int)));
	connect(p2k, SIGNAL(clicked()), SLOT(slotPos2Kap()));
  connect(k2p, SIGNAL(clicked()), SLOT(slotKap2Pos()));


	slotReturnPressed();
}

QString BibText::lesBuchName() {
	return (namebuch);
}

QString BibText::lesBuchDir() {
	return (buchdir);
}

int BibText::lesVonPos() {
	return (vonpos);
}

int BibText::lesBisPos() {
	return (bispos);
}
	
int BibText::lesVonKap() {
	return (vonkap);
}

int BibText::lesBisKap() {
	return (biskap);
}

int BibText::lesVonVers() {
	return (vonvers);
}


int BibText::lesBisVers() {
	return (bisvers);
}

QString BibText::lesKapVersVon(){
	return (kvon->text());
}

QString BibText::lesKapVersBis() {
	return (kbis->text());
}

void BibText::setBuchDir(QString bd) {
	buchdir = bd;

// neue Liste aufbauen
  buch->clear();
//	QDir hebdir(buchdir + "/he", "*.cod");
	QDir hebdir(buchdir, "*.cod");
	const QFileInfoList *list = hebdir.entryInfoList();
  QFileInfoListIterator it( *list );
  QFileInfo *bname;

  while ((bname = it.current()) != 0) {
		bname->setFile(hebdir, bname->baseName() + ".idx");
   	if  (bname->exists()) buch->insertItem(bname->baseName());
    ++it;
  }

}

void BibText::setBuchName(QString nb) {
	namebuch = nb;
	for (int i=0; i<buch->count(); i++)
		if (nb == buch->text(i)){
			buch->setCurrentItem(i);
			return;
		}
	QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the book ")+ namebuch +
												 i18n("\nin the directory ") + lesBuchDir());
		
}

void BibText::setKapVersVon(QString kvv) {

	QString tmp;
	tmp = kvv;
	vonkap = (tmp.left(tmp.find(CVSTS))).toInt();
	tmp.remove(0, (tmp.find(CVSTS) + 1));
	vonvers = tmp.toInt();
	writeKapVers();

//	kvon->setText(kvv);
}

void BibText::setKapVersBis(QString kvb) {

	QString tmp;
	tmp = kvb;
	biskap =  (tmp.left(tmp.find(CVSTS))).toInt();
	tmp.remove(0, (tmp.find(CVSTS) + 1));
	bisvers = tmp.toInt();

	writeKapVers();
//	kbis->setText(kvb);
}

void BibText::setPosVon(int p) {
	QString t="";
	pvon->setText(t.setNum(p));
	vonpos = p;
}

void BibText::setPosBis(int p) {

	QString t="";
	pbis->setText(t.setNum(p));
	bispos = p;
}


BibText::~BibText(){

}

void BibText::writeKapVers() {

	QString t;
	t = t.setNum(vonkap) + CVSEP + t.setNum(vonvers);
  kvon->setText(t);

	t = t.setNum(biskap) + CVSEP + t.setNum(bisvers);
  kbis->setText(t);
		
}

/** Open a book directory */
void BibText::slotOpenBookDir(int id){

	QString newdir = QFileDialog::getExistingDirectory(lesBuchDir(), this, i18n("select bookdir..."));
	if(!newdir.isEmpty()) setBuchDir(newdir);
	
}

/** Text gendert Eingabefeld (ve. Validatorersatz)*/
void BibText::slotTextChanged(const char *txt){

}

/** Book changed */
void BibText::slotBookChanged(int i){

	BHebIdx *hebidx = new BHebIdx();
	
	namebuch = buch->currentText();
	setPosVon(0);
	hebidx->endBuch(namebuch);
	setPosBis(hebidx->versdat.epos);
	slotPos2Kap();

}

void BibText::slotPos2Kap(){

	BHebIdx *hebidx = new BHebIdx();
	slotReturnPressed();
	hebidx->posKap(namebuch, vonpos);
	vonkap = hebidx->versdat.kap;
	vonvers = hebidx->versdat.vers;

	hebidx->posKap(namebuch, bispos);
	biskap = hebidx->versdat.kap;
	bisvers = hebidx->versdat.vers;

	writeKapVers();
}

void BibText::slotKap2Pos(){

	BHebIdx *hebidx = new BHebIdx();
  slotReturnPressed();
  hebidx->kapPos(namebuch, vonkap, vonvers);
	setPosVon(hebidx->versdat.bpos);
	setPosBis(hebidx->kapPos(namebuch, biskap, bisvers));
}
	

// Bei Return in einem Eingabefeld werden alle Werte neu gelesen
// spter mit validator (Eingabeprfung)

void BibText::slotReturnPressed() {

	QString lin;

	lin = pbis->text();
	bispos = lin.toInt();

  lin = pvon->text();
	vonpos = lin.toInt();

	lin = kvon->text();
	vonkap =   (lin.left(lin.find(CVSTS))).toInt();
	lin.remove(0, (lin.find(CVSTS) + 1));
	vonvers = lin.toInt();

	lin = kbis->text();
	biskap =   (lin.left(lin.find(CVSTS))).toInt();
	lin.remove(0, (lin.find(CVSTS) + 1));
	bisvers = lin.toInt();

	namebuch = buch->currentText();

}














































