/***************************************************************************
                          bhebidx.h  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef BHEBIDX_H
#define BHEBIDX_H

/**
  *@author Heinz Schumann

 The class off BHebIdx make all process with the index-file and run as
 children prozess. The class working intern, and make no information off
 widget. This class use the files by extension '*.idx'. To come into the
 bookname as argument off constructor. For comunication with the
 ovner-prozess is the public-structure 'versdat' and the public-string
 'text' connected.
 @see lesVers();
 @see kapPos();
 @see posKap();
*/

#include <qobject.h>
#include <qfile.h>

#define ANZWRT 150
#define SEP    '\t'

class BHebIdx : public QObject
{
 Q_OBJECT

 public:

/**
 The datastructure off vers for hebr.bibletext  for communication
 with the ovner prozess
*/
  QString text;               // Text off vers as hebr. letter.

/**
 The datastructure off versdata for communication with the ovner prozess
*/
  struct
  {
   int  kap;         // Chapter
   int  vers;        // Vers
   int  bpos;        // Beginposition of Vers in code-datei
   int  epos;        // Endposition of Vers in code-datei
   char kapvers[9];  // Chapter, vers and marking off vers as string
  } versdat;

/**
 The constructor
*/
	BHebIdx();

/**
 The destructor closed the indexfile
*/
virtual	~BHebIdx();

/**
 This method 'LesVers' read a vers in a hebrew book and write the text in
 the public string 'text'. In the parameter is any data position to declare.
 The number off data position is the number to unite letter in book.
 Return is the endposition of the verse, or -1 if not found.
 @see nextIdxSatz();
 @see transStr();
*/
 int lesVers(QString, int);

/**
 This method 'posKap' search the idxrecord in a hebrew idxfile within the
 position 'pos' is, and create the public structure 'versdat'.
 Return is the endposition of the verse, or -1 if not found.
*/
 int posKap(QString, int);

/**
 This method 'kapPos' search the idxrecord in a hebrew idxfile to the
 chapter 'kap' and the verse 'vers', and create the public structure
 'versdat'.
  Return is the endposition of the verse, or -1 if not found.
*/
 int kapPos(QString, int, int);

/**
 This method 'endBuch' serch the last chapter and verse in the book and
 create the public structure 'versdat'
 Return is the endposition of the book, or -1 if not found.
*/
 int endBuch(QString);

 private:
/**
 Read out the next indexrecord
*/
  int nextIdxSatz();
/**
 Move and modify the date from the index in the public-structure 'versdat'.
*/
  void transStr();
/**
 Check and opened the index file. The method opening the indexfile.
 As parameter to come into the bookname (without extension).
*/
 bool openBuch(QString);
/**
 Declare the intern index structure
*/
  struct IDXKOP
  {
    short   kap;        // Chapter as Integer
    char   vers;        // Vers as Interger
    char   soze;        // Marking off Vers
    int    bpos;        // Beginposition Vers
    int    epos;        // Endposition Vers
  };

 union uniidx
 {
  IDXKOP idxkop;
  char idxstr[sizeof(IDXKOP)];
 };

/**
 Declare the union
 Character chain for reading any record off index
*/
  uniidx idx;
  char   wrtbu[ANZWRT];                // Quanti letter at a word

/**
 Working variable
*/
  QString name;                        // File name
  uint    datlng;                      // File length
  QFile f1, f2;
};

#endif




