/***************************************************************************
                          banalyse.h  -  description
                             -------------------
    begin                : Wed Dec 22 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BANALYSE_H
#define BANALYSE_H

/**
  *@author Heinz Schumann

 *The class of 'BAnalyse' analyze the occur of ELS to hebrew word in the
 biblebook and output the results in 5 list's.
 *This list is
 *'ana1.lst' Table of minimal-domain for ELS
 *'ana2.lst' Grafic picture to by found ELS as difference to statistic
            pending.

 @see Algorithm of statisitc pending (Handbook)

 *'ana3.lst' Grafic picture off frequency distribution of ELS sequenz
 *'ana4.lst' Grafic picture off frequency distribution of ELS startposition
 *'ana5.lst' Grafic picture to by found ELS as difference to medial by
            found ELS with words for to change letters.

 @see Algorithm of medial to by found (Handbook)
*/
#include <qobject.h>

class BGrafikSatz;
class BHebIdx;
class BHebBuch;

class BAnalyse : public QObject
{
 Q_OBJECT

 public:
	BAnalyse();
	~BAnalyse();

/**
 *This method 'intervallAnalyse' analyze the occur of ELS to hebrew word
 in the biblebook and output the results in 5 list's.
 *Parameters the methode is:
 *1. Name of biblebook
 *2. Hebrew word
 *3. Begining seqenz of ELS
 *4. End seqenz of ELS
 *5. ELS-Route (0=double-sided, 1=forward, 2=backward)
*/
  bool intervallAnalyse(QString, QString, int, int, int);

public slots:

 void slotStop();

private:
 BHebBuch    *_heb;
 BHebIdx     *_idx;
 BGrafikSatz *_gra;

 bool _stop;                           // Market stop
};

#endif











