/***************************************************************************
                          banalyse.cpp  -  description
                             -------------------
    begin                : Wed Dec 22 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qobject.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "banalyse.h"
#include "bhebbuch.h"
#include "bhebidx.h"
#include "bgrafiksatz.h"
#include "bitana.h"

#define FENBRT 700
#define FENHOE 500
#define SCHBRT 200

BAnalyse::BAnalyse()
{
 _heb=new BHebBuch();
 _idx=new BHebIdx();
 _gra=new BGrafikSatz();
}

BAnalyse::~BAnalyse()
{
 delete _heb;
 delete _idx;
 delete _gra;

 extern BitanaApp *bitana;
 disconnect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));
}

bool BAnalyse::intervallAnalyse(QString buch, QString wort,
                                int vint, int bint,
                                int richt)
{
 struct STREIN
  {
   int  apos;                          // Startposition ELS
   int  epos;                          // Endposition ELS
   int  inter;                         // Sequenz ELS
   int  richt;                         // Route ELS
  };

  union UNIEIN
  {
   STREIN sein;
   char   cein[sizeof(STREIN)];
  };

 extern BitanaApp *bitana;

 _stop = false;

 connect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));

// Delete the old version outputfile
 QFile a1;
 QDir d=QDir::root();
 d.cd(bitana->getTmpDir());
 a1.setName(d.filePath("ana1.lst"));
 a1.remove();
 a1.setName(d.filePath("ana2.lst"));
 a1.remove();
 a1.setName(d.filePath("ana3.lst"));
 a1.remove();
 a1.setName(d.filePath("ana4.lst"));
 a1.remove();
 a1.setName(d.filePath("ana5.lst"));
 a1.remove();

 int wrtlng=wort.length();
 uint datlng=_heb->lngBuch(buch);
 if(datlng==0) return FALSE;
 int vpos=0;
 int bpos=datlng-1;

// Fixed ELS range of 2 to maxinter by erw>1000 ELS
 vint=2;
 float erw=0.0;
 int maxint=1;
 while(erw<1000.0)
 {
  if(maxint<10)  maxint++;
  else if(maxint<100) maxint+=10;
       else if(maxint<1000) maxint+=100;
            else maxint+=1000;
  erw=_heb->intervallErwart(buch,wort,vpos,bpos,2,maxint,0);
  if(maxint>int(datlng/(wrtlng-1))) break;
 }
 bint=maxint;

// Controll input data
 if(wrtlng<3)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have not given (or to short)  input word."));
   return FALSE;
 }
 if(datlng<(uint)wrtlng)
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("You have not given (or to short) search length."));
   return FALSE;
 }

// Control data length with search length
 if(datlng<(uint)bpos)
 {
  switch (QMessageBox::information(0,i18n("Warning: Datasection searchtext"),
                          i18n("Datasection to long\nsetting of correct length???"),
                          i18n("&Yes"),i18n("&No=Cancel"), 0, 1))
   {
    case 0:
      bpos=datlng-1;
      break;
    case 1: return FALSE;
   }
 }

 _heb->modifiWort(wort);
 bool ok=_heb->modifiText(buch);
 if(!ok) return FALSE;

// Filename for ELS buffer
 QString zwnam="ilst.zwi";


// ELS file
 int anz=_heb->listeIntervall(buch,wort,vpos,bpos,vint,bint,0,zwnam);
 if(anz<0) return false;

// Create inputfile ELS
 UNIEIN ein;
 QFile  e1;
 d=QDir::root();

 if (d.cd(bitana->getTmpDir())) e1.setName(d.filePath(zwnam));
 else
 {
  QMessageBox::warning(0,i18n("Cannot open the working directory"),
                              bitana->getTmpDir());
  return FALSE;
 }

 if (!e1.open(IO_ReadOnly))
 {
  QMessageBox::warning(0,i18n("Cannot find the file: \n"),
                         i18n("Tempfile ")+zwnam);
  return false;
 }

 // Open the files 'ana1.lst' to write max range off ELS
 QFile a2;
 a2.setName(d.filePath("ana1.lst"));
 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file: "),
                         a2.name());
   return false;
 }


// Create max range list for ELS
 QTextStream tab(&a2);
 QString     tmp;
 QString     lstp;

 tab<<"# Tabelle"<<endl;
 tab<<i18n("# \t7\tSequenz\t60\tRoute\t20\tStartpos\t80\tEndpos\t80\t");
 tab<<i18n("Rangebegin\t80\tRangeend\t80\tPercent\t60\t")<<endl;
 tab<<i18n("# Maximal range for ELS to ")<<wort<<i18n(" in ");
 tab<<buch.upper()<<endl;
 tmp.setNum(vpos);
 lstp=i18n("# From position ")+tmp+"(";
 _idx->posKap(buch, vpos);
 tmp=_idx->versdat.kapvers;
 lstp+=tmp.left(6)+")";
 tmp.setNum(bpos);
 lstp+=i18n(" to position ")+tmp+"(";
 _idx->posKap(buch, bpos);
 tmp=_idx->versdat.kapvers;
 tmp+=")";
 lstp+=tmp.left(6)+")";
 tab<<lstp<<endl;

// Calculate maximal range off ELS
 struct ZWIFLD
 {
  int  inter;
  uint apos;
  uint epos;
  uint berb;
  uint bere;
  int  proz;
  int  richt;
 };

 ZWIFLD z[anz];
 int i,j,zw;

 for(i=0;i<anz;i++)
 {
  z[i].inter=999999;
  z[i].apos=0;
  z[i].epos=0;
  z[i].berb=vpos;
  z[i].bere=bpos;
  z[i].proz=0;
 }

 bitana->progressStart(anz, i18n("Sort ELS for analysis ..."));

// Sort ELS to sequenz
 e1.at(0);
 int l=0;
 while(!e1.atEnd())
 {
  if(_stop)
  {
   bitana->progressEnd();
   return false;
  }
  e1.readBlock(ein.cein,sizeof(STREIN));
  l++;
  bitana->progressStep(l);

  if(ein.sein.apos>ein.sein.epos)
  {
   zw=ein.sein.apos;
   ein.sein.apos=ein.sein.epos;
   ein.sein.epos=zw;
  }
  i=0;
  while(ein.sein.inter>=z[i].inter && i<anz) i++;
  if(i<anz)
  {
   if(z[i].inter<999999) for(j=anz-1;j>i;j--) z[j]=z[j-1];
    z[i].inter=ein.sein.inter;
    z[i].apos=ein.sein.apos;
    z[i].epos=ein.sein.epos;
    z[i].richt=ein.sein.richt;
  }
 }

 bitana->progressEnd();
 bitana->progressStart(anz, i18n("Make list ELS range ..."));

// Calculate maximal range
 i=0;
 j=1;
 while(i<anz)
 {
  if(i>0) j=0;
  bitana->progressStep(i);
  if(_stop)
  {
   bitana->progressEnd();
   return false;
  }
  while(j<anz)
  {
   if(i!=j)
   {
    if(z[i].inter<=z[j].inter || z[i].bere==0) break;

// Down range limit
    if(z[i].apos>=z[j].epos &&
       z[i].berb<z[j].epos) z[i].berb=z[j].epos+1;

// Up range limit
    if(z[i].epos<=z[j].apos &&
       z[i].bere>z[j].apos) z[i].bere=z[j].apos-1;

// In rage limit
    if(z[i].berb<=z[j].apos && z[i].bere>=z[j].epos)
    {
     z[i].berb=z[j].apos;
     z[i].bere=z[j].epos;
     if(z[i].berb>z[i].apos || z[i].bere<z[i].epos)
     {
      z[i].berb=0;
      z[i].bere=0;
     }
     break;
    }
   }
   j++;
  }
  i++;
 }
 bitana->progressEnd();

 bitana->progressStart(anz, i18n("Write list ELS range ..."));

// Calculate percent
 for(i=0;i<anz;i++)
{
        if(z[i].bere>0) z[i].proz=(z[i].bere-z[i].berb)*100/(bpos-vpos);
        if(z[i].proz==0) z[i].bere=0;
}

// Make output liste
 QString lste;

 j=0;
 while(j<anz)
 {
  if(_stop)
  {
   bitana->progressEnd();
   return false;
  }
  bitana->progressStep(i);
  i=j;
  while(z[j].inter==z[i].inter)
  {
   if(z[j].proz<z[i].proz) j=i;
   i++;
   if(i>=anz) break;
  }
  if(z[j].bere>0)
  {
   tmp.setNum(z[j].inter);
   lste=tmp+SEP;
   if(z[j].richt) lste+="R";
   else lste+="V";
   tmp.setNum(z[j].apos);
   lste+=SEP+tmp+SEP;
   tmp.setNum(z[j].epos);
   lste+=tmp+SEP;
   tmp.setNum(z[j].berb);
   lste+=tmp+SEP;
   tmp.setNum(z[j].bere);
   lste+=tmp+SEP;
   tmp.setNum(z[j].proz);
   lste+=tmp;
   tab<<lste<<endl;
  }
  j=i;
 }
 a2.close();

 bitana->progressEnd();

 bitana->progressStart(anz, i18n("Make picture difference ..."));

// Grafic tool
 _gra->setzFenster(FENBRT,FENHOE);
 _gra->setzMassstab(0,datlng,-25,25);

// Open the files 'ana2.lst' to write picture diferent to statistic pending
// and create haed for diferent list off ELS
 ok=_gra->openDatei("ana2.lst");
 if(!ok) return false;
 _gra->schreibText("# Grafik");
 _gra->schreibText("# ");

 lste=i18n("# Difference to statistic expection for ELS to ");
 lste+=wort+" in "+buch.upper();
 _gra->schreibText(lste);
 _gra->schreibText(lstp);


// Make scala
 _gra->zeichneSkala('x',1,i18n("Position"));       // x-scala
 _gra->zeichneSkala('y',1,i18n("ELS difference")); // y-scala
 _gra->maleLinie(2,0,0,datlng,0);                  // Zero line

// Calculate the section off text
 int absint=SCHBRT;
 int abschn=absint*(wrtlng-1);   // Range length
 int abbeg=vpos;
 int abend=abschn;

// Calculate function
 maxint=0;
 int anzint=0;
 int lfdint=0;
 int erg=0;
 int f=0;
 float erwart=0.0;
 while(abend<=bpos)
 {
  erwart=_heb->intervallErwart(buch,wort,abbeg,abend,vint,absint,richt);
  erg=(int)erwart;
  e1.at(0);
  l=0;
  while(!e1.atEnd())
  {
   e1.readBlock(ein.cein,sizeof(STREIN));
   l++;
   if(_stop)
   {
    bitana->progressEnd();
    return false;
   }
   bitana->progressStep(l);
   if(ein.sein.apos>ein.sein.epos)
   {
    zw=ein.sein.apos;
    ein.sein.apos=ein.sein.epos;
    ein.sein.epos=zw;
   }
   if(ein.sein.apos>abend) break;
   if(ein.sein.apos>=abbeg)
   {
    lfdint++;
    if(ein.sein.epos<=abend && ein.sein.inter<=absint) anzint++;
   }
  }
  if(anzint-erg<0) f=3;
  else f=4;
  _gra->maleBalken(f,abbeg,0,abend,anzint-erg);
  if(abend==bpos) break;
  abbeg=abend+1;
  abend+=abschn+1;
  if(abend>bpos)
  {
   abend=bpos;
   absint=(abend-abbeg)/(wrtlng-1);
   if(absint<vint) break;
  }
  anzint=0;
  if(lfdint>maxint) maxint=lfdint;
  lfdint=0;
 }
 _gra->closeDatei();
 bitana->progressEnd();

// Open the files 'ana3.lst' to write picture many Els to position
// and create haed for list off ELS
 bitana->progressStart(anz, i18n("Please wait ..."));

 _gra->setzFenster(FENBRT,FENHOE);
 _gra->setzMassstab(0,datlng,0,maxint+2);

 _gra->openDatei("ana3.lst");
 _gra->schreibText("# Grafik");
 _gra->schreibText("# ");

 lste=i18n("# Number of ELS start-points to data position for ");
 lste+=wort+" in "+buch.upper();
 _gra->schreibText(lste);
 _gra->schreibText(lstp);

// Make scala
 _gra->zeichneSkala('x',1,i18n("Position"));       // x-scala
 _gra->zeichneSkala('y',1,i18n("Number of ELS"));  // y-scala

 abbeg=vpos;
 abend=abschn;

// Calculate function
 anzint=0;
 maxint=0;
 lfdint=0;
 while(abend<=bpos)
 {
  e1.at(0);
  l=0;
  while(!e1.atEnd())
  {
   e1.readBlock(ein.cein,sizeof(STREIN));
   l++;
   if(ein.sein.apos>ein.sein.epos)
   {
    zw=ein.sein.apos;
    ein.sein.apos=ein.sein.epos;
    ein.sein.epos=zw;
   }
   if(ein.sein.apos>abend) break;
   if(ein.sein.apos>=abbeg)
   {
    anzint++;
    if(maxint<ein.sein.inter) maxint=ein.sein.inter;
   }
  }
  _gra->maleBalken(5,abbeg,0,abend,anzint);
  if(abend==bpos) break;
  abbeg=abend+1;
  abend+=abschn+1;
  if(abend>bpos)
  {
   abend=bpos;
   absint=(abend-abbeg)/(wrtlng-1);
   if(absint<vint) break;
  }
  if(lfdint<anzint) lfdint=anzint;
  anzint=0;
 }
 _gra->closeDatei();

// Open the files 'ana4.lst' to write picture many Els to position
// and create haed for list off ELS
 _gra->setzFenster(FENBRT,FENHOE);

 _gra->openDatei("ana4.lst");
 _gra->schreibText("# Grafik");
 _gra->schreibText("# ");

 lste=i18n("# Number of ELS to sequenz for ");
 lste+=wort+" in "+buch.upper();
 _gra->schreibText(lste);
 _gra->schreibText(lstp);

// Calculate picture
 int sum[maxint+1];
 for(i=0;i<maxint;i++) sum[i]=0;
 e1.at(0);
 l=0;
 while(!e1.atEnd())
 {
  e1.readBlock(ein.cein,sizeof(STREIN));
  l++;
  sum[ein.sein.inter]++;
 }
 lfdint=0;

// Define y-scale
 for(i=0;i<maxint;i++) if(sum[i]>lfdint) lfdint=sum[i];

// Make scala
 _gra->setzMassstab(1,maxint+5,0,lfdint+2);
 _gra->zeichneSkala('x',1,i18n("Sequenz"));        // x-scala
 _gra->zeichneSkala('y',1,i18n("Number of ELS"));  // y-scala

// Make picture
 for(i=0;i<maxint;i++) if(sum[i]!=0) _gra->maleBalken(5,i,0,i+2,sum[i]);

 _gra->closeDatei();

 bitana->progressEnd();

// Define the random function for words
int rdlst[5][6][7]={
                   {
                    {0,1,2,9,9,9,9},
                    {0,2,1,9,9,9,9},
                    {1,2,0,9,9,9,9},
                    {1,0,2,9,9,9,9},
                    {2,0,1,9,9,9,9},
                    {1,2,0,9,9,9,9},
                   },
                   {
                    {0,1,2,3,9,9,9},
                    {0,2,3,1,9,9,9},
                    {1,2,0,3,9,9,9},
                    {1,3,0,2,9,9,9},
                    {2,1,3,0,9,9,9},
                    {3,1,0,2,9,9,9},
                   },
                   {
                    {0,1,2,3,4,9,9},
                    {1,3,2,0,4,9,9},
                    {2,1,4,0,3,9,9},
                    {3,0,1,4,2,9,9},
                    {4,3,0,2,1,9,9},
                    {4,0,2,3,1,9,9},
                   },
                   {
                    {0,1,2,3,4,5,9},
                    {1,3,5,4,0,2,9},
                    {2,4,1,5,3,0,9},
                    {3,5,2,0,1,4,9},
                    {4,0,3,5,1,2,9},
                    {5,2,4,0,3,1,9},
                   },
                   {
                    {0,1,2,3,4,5,6},
                    {1,6,5,3,4,0,2},
                    {2,4,3,6,5,1,0},
                    {3,6,4,5,0,2,1},
                    {4,0,3,5,1,2,6},
                    {5,4,0,6,2,3,1},
                   }
                  };

// Open the files 'ana5.lst' to write picture many Els to position
// and create haed for list off ELS
 _gra->setzFenster(FENBRT,FENHOE);
 _gra->setzMassstab(0,datlng,0,maxint+2);

 _gra->openDatei("ana5.lst");
 _gra->schreibText("# Grafik");
 _gra->schreibText("# ");

 lste=i18n("# Number of ELS start-points to compare with 5 random words for ");
 lste+=wort+" in "+buch.upper();
 _gra->schreibText(lste);
 _gra->schreibText(lstp);

 int anzsch=datlng/abschn;
 int fsp[7][anzsch];

 for(i=0;i<7;i++) for(j=0;j<anzsch;j++) fsp[i][j]=0;

 int anzbu=wort.length();
 if(anzbu>7) anzbu=7;
 maxint=0;

 QString rawrt;

// Calculate six functions
 for(i=0;i<6;i++)
 {
  e1.close();
  rawrt="";
  for(j=0;j<anzbu;j++) rawrt+=wort.at(rdlst[anzbu-3][i][j]);

  anz=_heb->listeIntervall(buch,rawrt,vpos,bpos,vint,bint,0,zwnam);
  if(anz<0) return false;

  if (!e1.open(IO_ReadOnly))
  {
   QMessageBox::warning(0,i18n("Cannot find the file"),
                          i18n("Tempfile ")+zwnam);
   return false;
  }

  bitana->progressStart(6, i18n("Make 6 list ELS to compare ..."));

  abbeg=vpos;
  abend=abschn;

// Calculate function
  anzint=0;
  lfdint=0;
  erg=0;
  if(_stop)
  {
   bitana->progressEnd();
   return false;
  }
  bitana->progressStep(i+1);
  while(abend<=bpos)
  {
   e1.at(0);
   while(!e1.atEnd())
   {
    e1.readBlock(ein.cein,sizeof(STREIN));

    if(ein.sein.apos>ein.sein.epos)
    {
     zw=ein.sein.apos;
     ein.sein.apos=ein.sein.epos;
     ein.sein.epos=zw;
    }
    if(ein.sein.apos>abend) break;
    if(ein.sein.apos>=abbeg) anzint++;
   }
   fsp[i][lfdint]=anzint;
   lfdint++;
   if(abend==bpos) break;
   abbeg=abend+1;
   abend+=abschn+1;
   if(abend>bpos)
   {
    abend=bpos;
    absint=(abend-abbeg)/(wrtlng-1);
    if(absint<vint) break;
   }
   if(maxint<anzint) maxint=anzint;
   anzint=0;
  }
  bitana->progressEnd();
 }

// Make scala
 _gra->setzMassstab(0,datlng,0,maxint+2);
 _gra->zeichneSkala('x',1,i18n("Position"));       // x-scala
 _gra->zeichneSkala('y',1,i18n("Number of ELS"));  // y-scala

// Calculate mean function out fife random words
 int wert1,wert2;

 for(j=0;j<anzsch;j++)
 {
  wert1=999999;
  lfdint=fsp[1][j];
  for(i=2;i<6;i++) if(lfdint>fsp[i][j]) lfdint=fsp[i][j];

  while(lfdint<maxint)
  {
   wert2=0;
   for(i=1;i<6;i++) wert2+=(abs(lfdint-fsp[i][j]))*(abs(lfdint-fsp[i][j]));
   if(wert1>wert2)
   {
    wert1=wert2;
    anzint=lfdint;
   }
   lfdint++;
  }
  fsp[6][j]=anzint;
 }

// Draw functions
 abbeg=vpos;
 abend=abschn;
 lfdint=0;
 erg=0;
 while(abend<=bpos)
 {
  _gra->maleLinie(8,abbeg,erg,abbeg,fsp[0][lfdint]);
  _gra->maleLinie(8,abbeg,fsp[0][lfdint],abend,fsp[0][lfdint]);
  erg=fsp[0][lfdint];
  lfdint++;
  if(abend==bpos) break;
  abbeg=abend+1;
  abend+=abschn+1;
  if(abend>bpos) abend=bpos;
 }

// The medium function
 abbeg=vpos;
 abend=abschn;
 lfdint=0;
 erg=0;
 while(abend<=bpos)
 {
  _gra->maleLinie(1,abbeg,erg,abbeg,fsp[6][lfdint]);
  _gra->maleLinie(1,abbeg,fsp[6][lfdint],abend,fsp[6][lfdint]);
  erg=fsp[6][lfdint];
  lfdint++;
  if(abend==bpos) break;
  abbeg=abend+1;
  abend+=abschn+1;
  if(abend>bpos) abend=bpos;
 }
 _gra->closeDatei();
 return TRUE;
}

void BAnalyse::slotStop()
{
  _stop = true;
}



























