/**************************************************************************
 * $Id: SamplinScaleBar.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SAMPLIN_SCALE_BAR_H
#define SAMPLIN_SCALE_BAR_H

#include <qstring.h>
#include <qwt_dimap.h>
#include <qwt_scldiv.h>
#include <qwt_autoscl.h>
#include <qfont.h>
#include <qrect.h>
#include <qcolor.h>
#include <qpen.h>

class SamplinScaleBar : public QwtDiMap, public QwtAutoScale
{
 public:
   SamplinScaleBar();
   virtual ~SamplinScaleBar();
   
   enum Orientation { Bottom, Top, Left, Right, Round 
   };
   enum Format {None, Scientific, General, Fixed
   };
   
// private:
//   QwtScaleDiv d_scldiv;

   //static members
   
   static int style(const char *);
   
 
 protected:
   static const int minLen;
   Orientation d_orient;

   int d_xorg, d_yorg, d_len;
   int d_hpad, d_vpad;
   int d_medLen, d_majLen, d_minLen;
   int d_minAngle, d_maxAngle;
   char d_fmt;
   int d_prec;
   QFont d_font;
   QPen d_pen;

   virtual void update(void);
   
 private:
   void drawTick(QPainter *p, double val, int len) const;
   void drawBackbone(QPainter *p) const;
   void drawLabel(QPainter *p, double val, int lwidth) const;
   void calcTicks();
	
 public:
   void setFont(const QFont &f){d_font=f;}
   void setPen(const QPen p){d_pen=p;}
   void setLabelFormat(Format f, int prec);
   const QFont &font(void) const {return d_font;}
   const QPen &pen(void) const {return d_pen;}
   int labelFormat(void) const {return d_fmt;}
   int labelPrec(void) const {return d_prec;}   
   
//   void setScale(double vmin, double vmax, int maxMajIntv, int maxMajIntv,
//		 double step = 0.0, int logarithmic = 0);
//   void setScale(const QwtScaleDiv &s);
   void setScale(double min, double max, double step=0.0){QwtAutoScale::setScale(min,max,step);}
//   using QwtAutoScale::setScale;
   
   void setGeometry(int xorigin, int yorigin, int length, Orientation o);
   int orientation() const { return d_orient; }
   void setAngleRange(double angle1, double angle2);
  
   const QwtScaleDiv& scalediv() const { return d_scldiv; }
   const QwtScaleDiv& scaleDiv() const;

   QRect maxBoundingRect(QPainter *p) const;
   int maxWidth(QPainter *p, bool worst = TRUE) const;
   int maxHeight(QPainter *p) const;
   int maxLabelWidth(QPainter *p, int worst) const;

   virtual void draw(QPainter *p) const;

};


inline const QwtScaleDiv & SamplinScaleBar::scaleDiv() const
{
    return d_scldiv;
}
#endif
