/**************************************************************************
 * $Id: GraphLegend.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "GraphLegend.h"
#include <kfontdialog.h>

#include "GraphLegend.moc"

#define Inherited GraphLegendData

GraphLegend::GraphLegend
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( "Graph options" );
}


GraphLegend::~GraphLegend()
{
}

void GraphLegend::setData(SamplinPlot *data)
{
   QString s;
   
   series=data;
   if(series!=NULL){
      d_lpos=data->legendPosition();
      d_cpos=data->commentPosition();
      d_lfnt=data->legendFont();
      d_nlfnt=d_lfnt;
      d_cfnt=data->commentFont();
      d_ncfnt=d_cfnt;
      d_lcolor=data->legendColor();
      d_ccolor=data->commentColor();
      d_comment=data->comment();

      inp_lpos->setCurrentItem(d_lpos);
      inp_cpos->setCurrentItem(d_cpos);
      inp_lcol->setColor(d_lcolor);
      inp_ccol->setColor(d_ccolor);
      inp_ctext->setText(d_comment);
   }
}

void GraphLegend::loadOld()
{
   
   if(series!=NULL){
      series->setLegendPosition(d_lpos);
      series->setCommentPosition(d_cpos);
      series->setLegendFont(d_lfnt);
      series->setCommentFont(d_cfnt);
      series->setLegendColor(d_lcolor);
      series->setCommentColor(d_ccolor);
      series->setComment(d_comment);
   }
}

void GraphLegend::loadBack(void)
{
   QPen pen;
   
   if(series!=NULL){
      series->setLegendPosition(inp_lpos->currentItem());
      series->setCommentPosition(inp_cpos->currentItem());
      series->setLegendFont(d_nlfnt);
      series->setCommentFont(d_ncfnt);
      series->setLegendColor(inp_lcol->color());
      series->setCommentColor(inp_ccol->color());
      series->setComment(inp_ctext->text());
   }
}

void GraphLegend::selectLFont()
{
   KFontDialog *fdlg;
	
   fdlg = new KFontDialog(this,"Select font",TRUE);
   fdlg->setFont(d_nlfnt);
   fdlg->show();
   if(fdlg->result()==QDialog::Accepted)
	       d_nlfnt=fdlg->font();
   
   delete fdlg;
}

void GraphLegend::selectCFont()
{
   KFontDialog *fdlg;
	
   fdlg = new KFontDialog(this,"Select font",TRUE);
   fdlg->setFont(d_ncfnt);
   fdlg->show();
   if(fdlg->result()==QDialog::Accepted)
	       d_ncfnt=fdlg->font();
   
   delete fdlg;
}

   
