/**************************************************************************
 * $Id: GraphLayout.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef GraphLayout_included
#define GraphLayout_included

#include "dlg/GraphLayoutData.h"
#include <SamplinPlot.h>

class GraphLayout : public GraphLayoutData
{
    Q_OBJECT

friend class GraphOptions;
   
public:

    GraphLayout
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~GraphLayout();

 protected:
   
   SamplinPlot *series;
   
   QString d_title;
   QFont d_font,d_nfont;
   QColor d_tcolor, d_pcolor, d_bcolor;
   int d_printwidth,d_printheight;
   bool d_printfit;
   void loadBack(void);
   void loadOld(void);
   
   void setData(SamplinPlot *);
   
 protected slots:
   virtual void selectFont();
   
};
#endif // GraphLayout_included
