/***************************************************************************
                          ksms_client.cpp  -  description
                             -------------------
    begin                : Sat Oct  9 09:56:30 CEST 1999
    copyright            : (C) 1999 by Andreas Bleischwitz & Joerg Zopes
    email                : Zab@Pironet.de & Joerg.Zopes@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ksms_client.h"

Ksms_client::Ksms_client(){
QFont f("Helvetica", 14, QFont::Bold);
int listwidth = 130;
  path = (QString)getenv("HOME") + (QString)"/sms_adrbook.dat";
QFileInfo File(path);

	if (!File.exists()){
		ofstream TempFile((const char *)path,ios::out);
		TempFile.close();
	}

	this->setFixedSize(650,400);

	filemenu = new QPopupMenu();
	filemenu->insertItem("&Load Adressbook",this,SLOT(slotimportadrbook()));
	filemenu->insertItem("&Save Adressbook",this,SLOT(slotexportadrbook()));
	filemenu->insertSeparator();	
	filemenu->insertItem("&Quit",qApp,SLOT(quit()));
	
	usermenu = new QPopupMenu();
	usermenu->insertItem("&Add Adress",this,SLOT(slotenteruserdata()));
	usermenu->insertItem("&Change Adress",this,SLOT(slotchangeuserdata()));
	usermenu->insertSeparator();
	usermenu->insertItem("&Delete Adress",this,SLOT(slotremoveentry()));

	helpmenu = new QPopupMenu();
	helpmenu->insertItem("&About",this,SLOT(slotabout()));
	helpmenu->insertItem("About &QT",this,SLOT(slotaboutqt()));

	mainmenu = new QMenuBar(this);
	mainmenu->insertItem("&File",filemenu);
	mainmenu->insertItem("&Adressbook",usermenu);
	mainmenu->insertSeparator();
	mainmenu->insertItem("&Help",helpmenu);

	userlist = new QListBox(this);
	userlist->setGeometry(0,mainmenu->height()+30,listwidth,this->height()-mainmenu->height()-55);
	connect(userlist,SIGNAL(selected(int)),this,SLOT(slotselect(int)));
	
	adrbooklabel = new QLabel(this);
	adrbooklabel->setGeometry(0,mainmenu->height()+5,userlist->width(),20);
	adrbooklabel->setBackgroundColor(QColor(128,128,0));
	adrbooklabel->setAlignment(AlignCenter);
	adrbooklabel->setText("Adressbook");
	
	messagewindow = new QMultiLineEdit(this);
	messagewindow->setGeometry(listwidth+150,mainmenu->height()+30,this->width()-listwidth-160,100);
	messagewindow->setFont(f);
	connect(messagewindow,SIGNAL(textChanged()),this,SLOT(slotCharCounter()));

	clearmessagebutton = new QPushButton("Clear Message Window",this);
	clearmessagebutton->setGeometry(messagewindow->x(),messagewindow->y()+messagewindow->height()+5,messagewindow->width(),20);
	connect(clearmessagebutton,SIGNAL(clicked()),this,SLOT(slotclearmessagewindow()));

	direkteingabe = new QLabel(this);
	direkteingabe->setGeometry(listwidth,mainmenu->height(),150,30);
	direkteingabe->setAlignment(AlignCenter);
	direkteingabe->setText("Direct Input");

	inputframe = new QFrame(this);
	inputframe->setGeometry(adrbooklabel->width()+2,mainmenu->height()+direkteingabe->height()-5,147,55);
  inputframe->setFrameStyle( QFrame::Panel | QFrame::Sunken );

	textheader = new QLabel(this);
	textheader->setGeometry(messagewindow->x(),mainmenu->height()+5,messagewindow->width()-50,20);
	textheader->setBackgroundColor(QColor(0,255,0));
	textheader->setText(" Message Window: Enter your message (max. 150)");
	
	charcounter = new QLCDNumber(3,this);
	charcounter->setGeometry(textheader->x()+textheader->width()+5,mainmenu->height(),45,30);
	emit charcounter->display(0);

	rufnummer = new QLabel(this);
	rufnummer->setGeometry(listwidth+5,mainmenu->height()+35,50,20);
	rufnummer->setText("PhoneNr.");

	phonenr = new QLineEdit(this);
	phonenr->setGeometry(listwidth+55,mainmenu->height()+30,90,20);

	netz = new QLabel(this);
	netz->setGeometry(listwidth+5,mainmenu->height()+55,50,20);
	netz->setText("Service");

	serviceentries = new QStrList(true);
	serviceentries->insert(serviceentries->count(),"CELLNET");
	serviceentries->insert(serviceentries->count(),"DETEMOBIL");
	serviceentries->insert(serviceentries->count(),"D2");
	serviceentries->insert(serviceentries->count(),"EPLUS");
	serviceentries->insert(serviceentries->count(),"TELENOR");
	serviceentries->insert(serviceentries->count(),"AZCOM");
	serviceentries->insert(serviceentries->count(),"TELESTRA");
	serviceentries->insert(serviceentries->count(),"VODAFONE");
	serviceentries->insert(serviceentries->count(),"VODAFONE_AUSTRALIA");
	serviceentries->insert(serviceentries->count(),"ORANGE");
	serviceentries->insert(serviceentries->count(),"MINICALL");
	serviceentries->insert(serviceentries->count(),"ONE2ONE");
	serviceentries->insert(serviceentries->count(),"VODAPAGE_BLOCK");
	serviceentries->insert(serviceentries->count(),"VODACOM");
	serviceentries->insert(serviceentries->count(),"KPN");
	serviceentries->insert(serviceentries->count(),"ANSWER");
	serviceentries->insert(serviceentries->count(),"MTN");
	serviceentries->insert(serviceentries->count(),"LIBERTEL");
	serviceentries->insert(serviceentries->count(),"TIM");
	serviceentries->insert(serviceentries->count(),"PROXIMUS");
	serviceentries->insert(serviceentries->count(),"AMPI");
	serviceentries->insert(serviceentries->count(),"EUROPOLITAN");
	serviceentries->insert(serviceentries->count(),"BTEASYREACH");
	serviceentries->insert(serviceentries->count(),"SWISSCOM");
	servicelist = new QComboBox(this);
  servicelist->setGeometry(netz->x()+netz->width(),mainmenu->height()+55,92,20);
  servicelist->insertStrList(serviceentries,-1);

	addbutton = new QPushButton(">>",this);
	addbutton->setGeometry(netz->x()+10,servicelist->y()+servicelist->height()+10,35,20);
	connect(addbutton,SIGNAL(clicked()),this,SLOT(slotaddbuttonclicked()));

	delbutton = new QPushButton("<<",this);
	delbutton->setGeometry(netz->x()+10,servicelist->y()+servicelist->height()+35,35,20);
	connect(delbutton,SIGNAL(clicked()),this,SLOT(slotdelbuttonclicked()));
      	
	receiverlist = new QListBox(this);
	receiverlist->setGeometry(userlist->x()+userlist->width()+10,servicelist->y()+servicelist->height()+80,130,170);
  receiver = new QLabel(this);
	receiver->setGeometry(receiverlist->x(),receiverlist->y()-20,receiverlist->width(),20);
	receiver->setAlignment(AlignCenter);
	receiver->setText("Recipient List");
	connect(receiverlist,SIGNAL(selected(int)),this,SLOT(slotdeselect(int)));

  clearreceiverlistbutton = new QPushButton("Clear Recipient List",this);
	clearreceiverlistbutton->setGeometry(receiverlist->x(),receiverlist->y()+receiverlist->height()+5,receiverlist->width(),20);
	connect(clearreceiverlistbutton,SIGNAL(clicked()),this,SLOT(slotclearreceiverlist()));
	
	sendbutton = new QPushButton("&Send",this);
	sendbutton->setGeometry(addbutton->x()+addbutton->width()+5,addbutton->y(),servicelist->width(),45);
	sendbutton->setFont(f);
	connect(sendbutton,SIGNAL(clicked()),this,SLOT(slotsend()));
	
	debuglabel = new QLabel(this);
	debuglabel->setGeometry(messagewindow->x(),clearmessagebutton->y()+clearmessagebutton->height()+5,messagewindow->width(),20);
	debuglabel->setAlignment(AlignCenter);
	debuglabel->setBackgroundColor(QColor(128,128,255));	
	debuglabel->setText("System / Debug Messages");

	debugwindow = new QListBox(this);
	debugwindow->setGeometry(debuglabel->x(),debuglabel->y()+debuglabel->height()+5,debuglabel->width(),160);

	statusbar = new QStatusBar(this);
	statusbar->setGeometry(0,this->height()-20,this->width(),20);
	emit statusbar->message("Test");	

	users=0;
	debug("%s",(const char *)path);	
	loaduserdata(path);
}

Ksms_client::~Ksms_client()
{
DataSet saverecord;
ofstream outputfile((const char *)path,ios::out);
 	if (users != 0){
		while(users->getpreviousptr() != 0)
			users = users->getpreviousptr();
		
		while (users->getnextptr() != 0){
			strcpy(saverecord.name,(const char*)users->getname());
			strcpy(saverecord.service,(const char*)users->getservice());
			strcpy(saverecord.phonenr,(const char*)users->getphonenr());
			outputfile.write((char*)&saverecord,sizeof(DataSet));
			outputfile.flush();
			users = users->getnextptr();
		}
		strcpy(saverecord.name,(const char*)users->getname());
		strcpy(saverecord.service,(const char*)users->getservice());
		strcpy(saverecord.phonenr,(const char*)users->getphonenr());
		outputfile.write((char*)&saverecord,sizeof(DataSet));
		outputfile.flush();
	}
	outputfile.close();	
}

void Ksms_client::slotCharCounter(){
QString OutString;
int Zahl=strlen(messagewindow->text());
	//OutString.setNum(Zahl);
	if (Zahl > 150){
		textheader->setBackgroundColor(QColor(255,0,0));
	}
	else
	{
		textheader->setBackgroundColor(QColor(0,255,0));
	}
	textheader->setText(" Message Window: Enter your message (max. 150)");
	emit charcounter->display(Zahl);
}

void Ksms_client::loaduserdata(const char *filename){
DataSet loadrecord;
UserSet *dummy;
ifstream inputfile(filename,ios::in);

	if(users != 0){
		while (users->getpreviousptr() != 0)
			users = users->getpreviousptr();
	}

	
	while (users != 0){
		dummy = users;
		users = users->getnextptr();
		delete dummy;
	}

	userlist->clear();

	while (!inputfile.eof()){
		inputfile.read((char*)&loadrecord,sizeof(DataSet));
		if (!inputfile.eof()){
			dummy = new UserSet();
			dummy->setpreviousptr(users);
			if (users != 0) users->setnextptr(dummy);
			dummy->setnextptr(0);
			dummy->setname(loadrecord.name);
			dummy->setservice(loadrecord.service);
			dummy->setphonenr(loadrecord.phonenr);
			userlist->insertItem(loadrecord.name,-1);
  		users=dummy;		
		}
	}	
	inputfile.close();

	emit statusbar->message("STNADAD ADDRESSBOOK " + (QString) filename +" LOADED!");
}

int Ksms_client::slotenteruserdata(){
DataSet tempdata;
UserSet *dummy;
int flag=true;

	emit statusbar->message("CREATE NEW USER");

	strcpy(tempdata.name,"");
	strcpy(tempdata.service,"");
	strcpy(tempdata.phonenr,"");

	tempwindow = new inputwindow(this,"InputWindow",&tempdata);
	tempwindow->exec();

	if (userlist->count() != 0){
		for (uint i=0;i<userlist->count();i++)
			if (strcmp(userlist->text(i),tempdata.name) == 0) flag = false;
	}

  if (flag == false){
		QMessageBox::information(this,"Error","Username already exists!");
		return false;
	}
		
	if (strlen(tempdata.name) != 0){
		dummy = new UserSet();
		dummy->setpreviousptr(users);
		if (users != 0) users->setnextptr(dummy);
		dummy->setnextptr(0);
		dummy->setname(tempdata.name);
		dummy->setservice(tempdata.service);
		dummy->setphonenr(tempdata.phonenr);
		userlist->insertItem(tempdata.name,-1);
		users=dummy;	
	}

	sortlist();

	emit statusbar->clear();

	return 0;
}

int Ksms_client::slotchangeuserdata(){
int position;
DataSet tempdata;
	
	emit statusbar->message("CHANGE USERDATA");

	if (userlist->currentItem() == -1) return -1;

	if (userlist->count() == 0) return -1;
	while ((users != 0) && (users->getpreviousptr() != 0))
		users = users->getpreviousptr();

	while ((users->getnextptr() != 0) && (users->getname() != userlist->text(userlist->currentItem())))
		users=users->getnextptr();

	position = userlist->currentItem();
	
	strcpy(tempdata.name,users->getname());
	strcpy(tempdata.service,users->getservice());
	strcpy(tempdata.phonenr,users->getphonenr());

	tempwindow = new inputwindow(this,"InputWindow",&tempdata);
	tempwindow->exec();

	if (strlen(tempdata.name) != 0){
		userlist->changeItem(tempdata.name,position);
		users->setname(tempdata.name);
		users->setservice(tempdata.service);
		users->setphonenr(tempdata.phonenr);
	}
	sortlist();

	emit statusbar->clear();

	return 0;
}

int Ksms_client::sortlist(){
UserSet * pointer1;
UserSet * pointer2;
int sortflag = true;
UserSet dummy;
	emit statusbar->message("SORT USERDAT");

	if (users == 0) return false;

	while (users->getpreviousptr() != 0)
		users = users->getpreviousptr();

	if (users->getnextptr() == 0) return false;

	while (sortflag){
		pointer1 = users;
		pointer2 = users->getnextptr();
		sortflag = false;
		do {
				if (strcmp(pointer1->getname(),pointer2->getname()) > 0){
					  dummy.setname(pointer2->getname());
						dummy.setservice(pointer2->getservice());
            dummy.setphonenr(pointer2->getphonenr());

						pointer2->setname(pointer1->getname());
            pointer2->setservice(pointer1->getservice());
						pointer2->setphonenr(pointer1->getphonenr());

						pointer1->setname(dummy.getname());
            pointer1->setservice(dummy.getservice());
						pointer1->setphonenr(dummy.getphonenr());
						sortflag = true;
				}
				pointer1 = pointer2;
				pointer2 = pointer2->getnextptr();
		} while (pointer2 != 0);
	}
	userlist->clear();

	while (users->getpreviousptr() != 0)
		users = users->getpreviousptr();

	while (users->getnextptr() != 0){
		userlist->insertItem(users->getname(),-1);
		users = users->getnextptr();
	}
	userlist->insertItem(users->getname(),-1);

	return 0;
}

int Ksms_client::slotremoveentry(){
UserSet * dummy;
UserSet * helpptr;
QString message;
int rc=0;

	if (userlist->currentItem() == -1) return -1;

	if (userlist->count() == 0) return -1;
	
	message = (QString)"You are erasing:\n" + (QString)userlist->text(userlist->currentItem()) + (QString)"\n\nAre you sure?\n";
	rc = QMessageBox::warning(this,"Attention",message,"&Erase","&Abort");
	if (rc == 1) return false;

	while ((users != 0) && (users->getpreviousptr() != 0))
		users = users->getpreviousptr();

	while ((users->getnextptr() != 0) && (users->getname() != userlist->text(userlist->currentItem())))
		users=users->getnextptr();

	if (users->getnextptr() != 0){
		dummy = users;
		users = users->getnextptr();
		users->setpreviousptr(dummy->getpreviousptr());
		if (dummy->getpreviousptr() != 0){
				helpptr = dummy->getpreviousptr();
				helpptr->setnextptr(users);
		}
	}
	else
	{
		if (users->getpreviousptr() != 0){
			dummy = users;
			users = users ->getpreviousptr();
			users->setnextptr(dummy->getnextptr());
			if (dummy->getnextptr() != 0){
				helpptr=dummy->getnextptr();
				helpptr->setpreviousptr(users);
			}
		}
		else
		{
			dummy = users;
			users = 0;
		}
	}

	delete dummy;

	while ((users != 0) && (users->getpreviousptr() != 0))
		users = users->getpreviousptr();

	userlist->clear();
	if (users == 0) return false;

	while (users->getnextptr() != 0){
		userlist->insertItem(users->getname(),-1);
		users = users->getnextptr();
	}
	userlist->insertItem(users->getname(),-1);	
	
	receiverlist->clear();
	emit statusbar->message("USERDATA REMOVED");

  return 0;
}

int Ksms_client::slotaddbuttonclicked(){
int flag=true;

	if (userlist->currentItem() == -1) return false;

	if (receiverlist->count() != 0){
		for (uint i=0;i<userlist->count();i++)
			if (strcmp(receiverlist->text(i),userlist->text(userlist->currentItem())) == 0) flag = false;
	}

  if (flag) receiverlist->insertItem(userlist->text(userlist->currentItem()),-1);
  emit statusbar->message("USER SELECTED");
	return true;
}

int Ksms_client::slotdelbuttonclicked(){
	if (receiverlist->currentItem() == -1) return false;
	
	receiverlist->removeItem(receiverlist->currentItem());
	emit statusbar->message("USER DESELECTED");
	return true;
}

void Ksms_client::slotclearreceiverlist(){
	receiverlist->clear();
}

void Ksms_client::slotclearmessagewindow(){
	messagewindow->clear();
}

int Ksms_client::execute(const char* cmd){
FILE *pi;
char bline[1024];

	emit statusbar->message("SENDING MESSAGE ......");
	this->repaint(false);
	debugwindow->clear();
	pi=popen(cmd,"r");
	if (pi) {
		while(1) {
			fgets(bline,sizeof(bline),pi);
			bline[strlen(bline)-1]='\0';
			if (feof(pi)) break;
			debugwindow->insertItem(bline,-1);
			for(int i=0;i<100;i++){
				qApp->processEvents();
				debugwindow->repaint(false);
			}
		}
		pclose(pi);
		}

	emit statusbar->message("DONE .....");

	return true;
}

int Ksms_client::slotsend(){
QString sendstring="";
UserSet * start;
QString service;
QString TempString="";

  if(strlen(messagewindow->text()) > 150){
		QMessageBox::warning(this,"ERROR","The message you enterd is to long\n Transmission aborted!","&OK");
		return false;
	}
	
	while (users->getpreviousptr() != 0)
		users = users->getpreviousptr();
	
	start = users;
	
	if ((receiverlist->count() == 0) && (strlen(phonenr->text())== 0)){
		QMessageBox::information(this,"!!! Attention !!!",
		"There is no recipient adress in the [Direct Input] field\n"
		"and no recipient adress in the [Recipient List].So there is\n"
		"no recipient at all to send this message to\n");
		return false;
	}
	
	if (strlen(messagewindow->text()) == 0){
		QMessageBox::information(this,"Error","There is no message specified!");
		return false;
	}

	if (strlen(phonenr->text()) != 0){
		sendstring = (QString)servicelist->currentText() + (QString)":" + (QString)phonenr->text();
	}

	for(uint i=0;i<receiverlist->count();i++)
	{
		users=start;
		while (users != 0){
			if (strcmp(users->getname(),receiverlist->text(i)) == 0){
				if (strlen(sendstring) != 0){
					sendstring = sendstring + ",";
				}
				sendstring = sendstring + users->getservice() + ":" + users->getphonenr();
			}
			users = users->getnextptr();			
		}
	}
	sendstring = "sms_client \42" + sendstring +  "\42 \42" + messagewindow->text() + "\42";
	execute(sendstring);
	//QMessageBox::information(this,"Test",sendstring);

  users = start;
	while (users->getnextptr() != 0)
		users = users->getnextptr();

	return true;
}

void Ksms_client::slotabout(){
QString message;
	message = (QString)"           KSMS_Client\n"+
						(QString)"           -----------\n\n"+
            (QString)"Produced 10/13/1999 by:\n\n"+
						(QString)"Andreas Bleischwitz,eMail:zab@pironet.de    \n"+
						(QString)"Joerg Zopes, eMail:Joerg.Zopes@t-online.de\n\n"+
						(QString)"Have a nice linux day!\n";
	QMessageBox::information(this,"KSMS_Client (c)",message);
}

void Ksms_client::slotaboutqt(){
	emit statusbar->message(" A COMMERCIAL BREAK ...... ;-)");
	QMessageBox::aboutQt(this);
	emit statusbar->clear();
}

void Ksms_client::slotselect(int item){
	emit statusbar->message("USER SELECTED");
	emit slotaddbuttonclicked();
}

void Ksms_client::slotdeselect(int item){
	emit statusbar->message("USER DESELECTED");
	emit slotdelbuttonclicked();
}

void Ksms_client::slotimportadrbook(){
QString Filename;
	Filename = QFileDialog::getOpenFileName(".","*",this);
	if(strlen(Filename) != 0){
		loaduserdata(Filename);
	}
	
}

void Ksms_client::slotexportadrbook(){
DataSet saverecord;
QString Filename;
	Filename = QFileDialog::getSaveFileName(".","*",this);
ofstream outputfile((const char *)Filename,ios::out);
	if(strlen(Filename) != 0){
	 	if (users != 0){
			while(users->getpreviousptr() != 0)
				users = users->getpreviousptr();
		
			while (users->getnextptr() != 0){
				strcpy(saverecord.name,(const char*)users->getname());
				strcpy(saverecord.service,(const char*)users->getservice());
				strcpy(saverecord.phonenr,(const char*)users->getphonenr());
				outputfile.write((char*)&saverecord,sizeof(DataSet));
				outputfile.flush();
				users = users->getnextptr();
			}
			strcpy(saverecord.name,(const char*)users->getname());
			strcpy(saverecord.service,(const char*)users->getservice());
			strcpy(saverecord.phonenr,(const char*)users->getphonenr());
			outputfile.write((char*)&saverecord,sizeof(DataSet));
			outputfile.flush();
		}
		outputfile.close();	
	}
}

