#ifndef __MAZE_H_INCLUDED__
#define __MAZE_H_INCLUDED__

class CWormPlayground;

#include "ball.h"

#include <qobject.h>
#include <qpoint.h>
#include <qpainter.h>
#include <qpaintdevice.h>
#include <qlist.h>
#include <qrect.h>

#define DATA_NONE 0
#define DATA_WALL_1 1
#define DATA_WALL_2 2
#define DATA_WALL_3 3

// The worm may pass, the ball cannot
#define DATA_SEPARATOR 0x10
#define DATA_SEPARATOR_VISIBLE 0x11
#define DATA_CUTTER 0x12

#define DATA_OW_RIGHT 0x30
#define DATA_OW_UP 0x31
#define DATA_OW_LEFT 0x32
#define DATA_OW_DOWN 0x33
#define DATA_EXIT_1 0x41
#define DATA_EXIT_1_OPEN 0x51

//Teleports: 0xa0 - 0xbf
//Corresponding exits: add 0x20 to teleport number -> 0xc0 - 0xdf
#define DATA_TELEPORT_B 0xa0
#define DATA_TELEPORT_C 0xbf
#define DATA_TELEPORT_EX_B 0xc0
#define DATA_TELEPORT_EX_C 0xdf

// Difference between the values of a teleport's exit and the teleport itself
#define TELEPORT_EXIT_DIFF (DATA_TELEPORT_EX_B - DATA_TELEPORT_B)

typedef unsigned char byte;

// When a teleport is used, this point is added to the worm's list of turnpoints 
//#define TurnPointTeleport QPoint(200,200)

class CMaze : public QObject
{
 Q_OBJECT

 public:
	CMaze(CWormPlayground* pg);
	virtual ~CMaze();

 public:
	char accessible(QPoint field,char dir);
	void draw(QPainter* pt);
	void drawAt(QPoint field,QPaintDevice* dst,QPoint dstPoint);
	bool load(QString group,int nr);
	CWormPlayground* playground() { return _playground; }
	QPoint LPtoDP(QPoint pt);
	QRect LPtoDP(QRect rct);
	QPoint DPtoLP(QPoint pt);
	QRect DPtoLP(QRect rct);
	bool permExit() { return _permExit; }
	void onTeleport(QPoint tp);
	bool accessField(int x,int y);

 protected:
	CWormPlayground* _playground;
	size_t _allocSpace;
	void clear();
	void addBall();
	QList<CBall> _balls;
	bool _active;

	// Level Data
	byte* _data;
	char _mzAdditionalBalls;
	char _mzMinBalls;
	char _mzPercMvBalls;
	char _mzPercJmpBalls;
	
	bool _permExit;

	// Game Data
	char _eatenBalls; // Is ONLY increased when there has been only one ball in the field

 signals:
	void sigEatBall(char);
	void sigUpdate(const QRect&);
	void sigOpenExit();

 public slots:
        void slotTerminate(char reason);
        void slotStart();
	//void slotAccessField(int x,int y);
	void slotTimer(long c);
	void slotEatBall(char score);
	void slotTimerBar();

 //Implementation
 public:
	QPoint getCorrespondingExit(QPoint startPos);

 protected:
	void redraw(QRect* rct = NULL);
	void permitExit();



};

#endif // !__MAZE_H_INCLUDED__
