#include <casewidget.h>
#include <iostream.h>
#include <qpainter.h>

CaseWidget::CaseWidget(int ncol, int nrow, QWidget *parent, const char *name)
	: QTableView(parent,name)
{
	setNumCols(ncol);
	setNumRows(nrow);
	setCellWidth(50);
	setCellHeight(50);

	initStateTable();
}

void CaseWidget::initStateTable()
{
	for (int i=0;i<numRows();i++)
	   for (int j=0;j<numCols();j++)
		StateTable[i][j] = 0;
}

void CaseWidget::resizeEvent(QResizeEvent *e)
{
	setCellWidth(width()/numCols());
	setCellHeight(height()/numRows());
}

void CaseWidget::paintCell(QPainter *p, int row, int col)
{
	// First redraw the background if necessary
	if (backgroundPixmap()) {
		int	xPos = (col*cellWidth())%backgroundPixmap()->width(), yPos = (row*cellHeight())%backgroundPixmap()->height();
		p->drawTiledPixmap(0,0,cellWidth(),cellHeight(),*backgroundPixmap(),xPos,yPos);
	}
	else p->fillRect(0,0,cellWidth(),cellHeight(),backgroundColor());
	// Then the rectangle
	p->drawRect(0,0,cellWidth(),cellHeight());
	int	index(StateTable[row][col]-1);
	if (index >= 0) p->drawPixmap(0,0,*(Pix[index]));
}

void CaseWidget::setState(int row, int col, int state)
{
	StateTable[row][col] = state;
	updateCell(row,col,false);
}
