
// -*- c++ -*-

#ifndef PBUTTON_H
#define PBUTTON_H

#include <qpushbutton.h>
#include <qpainter.h>
#include <qdrawutl.h>
#include <qbrush.h>
#include "constants.h"
#include "pbutton.h" 


class PipeButton : public QPushButton
{
  Q_OBJECT

public:
  enum LinkType { Bomb,  Right, Down, Downright, 
                  Leftup, Cross, Upright, Leftdown,Empty, Start};

  enum Direction { North, East, South, West }; 


  PipeButton(QWidget * parent=0, const char * name=0, 
	     const QColor fluidcol = black); 
  ~PipeButton();

  void setLink(const LinkType type); 
  void setFluidCol(const QColor flCol=black); 
  LinkType getLink() { return lt;}
  void flow(Direction dir);
  int getHFill(){ return horzFill; }
  int getVFill(){ return vertFill;}
  void setStartDir(Direction d) { if(lt==Start) { startDir=d; paintEvent(0);}}

protected:
  void drawButton( QPainter * );
  void drawLink(QPainter *p, LinkType l, Direction fldir,
		int hFill, int vFill);

 signals:
  void pipeBroken();
  void linkFull(PipeButton::Direction);


private:
  QPainter *pt;
  LinkType lt;
  QColor pipeline,pipeback,fluid;

  // Prozentsatz, der schon durchflossen wurde.
  // in x- und y-Richtung. Kreuzungen koennen zu
  // "200%" gefuellt sein, die "Kurven" sind max.
  // zu je 50% horz. und 50% vert. gefuellt.

  // Starts werden auch gleichmaessig gefuellt,
  // bei der Punkteermittlung zaehlt dann nur
  // vertFill
  
  // Die Links werden jeweils in 10%-Schritten
  // durchflossen, die Anzanl der Schritte ist
  // in folgenden Variablen

  int horzFill,vertFill;
  
  // in welche Richtung fliesst das Zeug?
  Direction flowDir;
  // nur fuer LinkType::Start: wohin fliesst es beim Start?
  Direction startDir;


  
};

#endif









