
// -*- c++ -*-

#ifndef KPIPEWIDGET_H
#define KPIPEWIDGET_H

#include <qmlined.h>
#include <qvector.h>
#include <qframe.h>
#include <qtimer.h>
#include <qdatetime.h>
#include "playfield.h"
#include "status.h"

class KPipeWidget : public QWidget
{
  Q_OBJECT

public:
   KPipeWidget ( QWidget *parent = 0, const char *name = 0);
  //KPipeWidget ( QWidget *parent = 0, const char *name = 0/*, KConfig *conf = 0, int scheme = -1*/ 

  ~KPipeWidget();

signals:
  void startGame();
  void pumpingEvent();
 
 public slots:
  void newGame();
  void timerEvent();
  void endGame();

  void beginner();
  void advanced();
  void expert();
  void showHighscores();
  void oil();
  void water();
  void acid();

private:

  PlayField *field;
  Status *status;
  QTimer *timer;
  QTime  *time;
  QColor fluidCol;
  bool isFlowing,inGame;

  // startDelay: time in s before the oil/water/acid starts to flow
  // pumpingTime: time in ms needed to pump o/w/a 5 pixels wide
  int startDelay, pumpingTime;

  void closeEvent(QCloseEvent *e);
};

#endif // PipeView.H






