/***************************************************************************
                          kpicframer.h  -  description
                             -------------------
    begin                : Sat Mar 25 17:47:12 MET 2000
    copyright            : (C) 2000 by Norbert Andres
    email                : NAndres@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPICFRAMER_H
#define KPICFRAMER_H

#include "version.h"
#include "kcard.h"

#include <kapp.h>
#include <kaccel.h>
#include <kstdaccel.h>
#include <kmenubar.h>
#include <ktopwidget.h>
#include <kstatusbar.h>
#include <kconfig.h>

#include <qlabel.h>
#include <qtimer.h>
#include <qpopupmenu.h>
#include <qmessagebox.h>

#include <stdlib.h>

#define maxMark = 2


class kpicframer : public KTopLevelWidget
{
  Q_OBJECT 
  public:
    /** construtor */
    kpicframer(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~kpicframer();
		/* Public members */
	private:
		/** Keyboard Accelarators*/
		KAccel *kacc;
		/** counts how many fields are marked	*/
		int mcount;
		int lastField;
		int mindex1;	// index der ersten markierten Karte
		int mindex2;	// index der zweiten markierten Karte
		/** phase=0: game over, phase==1: laying down the cards, phase2 : picking them up */
		int phase;
		int score;
		
		int lostGames;
		int wonGames;
		int stoppedGames;
		int highScore;

//		bool running; // shows if the game is still alive
		int cStack[52]; // die Karten in der zu spielenden Reihenfolge
		int cardIndex; // Aktuelle Karte aus cStack
		KCard *stapel;
		KCard *activeCard;
		KCard *cards[16];
		QLabel *lCounter;
		QTimer *scoreTimer;
		KStatusBar *status;


		void initMenu();
		void initToolbar();
		void initPlayField();
		void readConfig();
		void saveConfig();

		
		int getFieldIndex(KCard *card);
		bool layDownCard(KCard* card);
		bool pickUpCard(KCard* card);
		int getSumme();
		void newCard();
		bool cardTest(KCard *card, int actCardNumber);
		int	emptyFieldsCount();
		bool stopCurrentGame();
		bool gameLost();
		void changeScore(int number);
		bool queryClose();
		void checkScore();
		bool pickupPossible();
		bool picFrameReady();
		void lost();
		void won();

	private slots:
		void quitGame();
		void initGame();
		void undo();
		void showStatistic();
		void changeOptions();
		void cardClicked(KCard*);
		void nextCard(KCard*);
		void scoreTimerEvent();
};

#endif
