#include <kpacmanwidget.h>
#include <kpacmanwidget.moc>

#include <kapp.h>
#include <qmsgbox.h>

#include "bitfont.h"
#include "score.h"
#include "referee.h"
#include "status.h"

KPacmanWidget::KPacmanWidget( QWidget *parent, const char *name, KConfig *conf, int scheme)
        : QWidget( parent, name )
{
    getScheme(conf, scheme);
    bitfont = new Bitfont(fontName, bitfontFirstChar, bitfontLastChar);
    if (bitfont->width() == 0 || bitfont->height() == 0) {
 	QString msg = i18n("The bitfont could not be contructed.\n\n"
			   "The file '@FONTNAME@' does not exist,\n"
			   "or is of an unknown format.");
	msg.replace(QRegExp("@FONTNAME@"), fontName);
	QMessageBox::information(this, i18n("Initialization Error"),
			 	 (const char *) msg);
    }

    score = new Score(this, name, bitfont);
    referee = new Referee( this, name, bitfont, pixDir);
    status = new Status(this, name, pixDir);

    setFixedSize(referee->width(),
	         bitfont->height()*3 + referee->height() + status->height());
}

KPacmanWidget::~KPacmanWidget()
{
}

void KPacmanWidget::getScheme(KConfig *conf, int Scheme)
{
    fontName = KApplication::kde_datadir() + "/kpacman/fonts/font.xbm";
    pixDir = KApplication::kde_datadir() + "/kpacman/pics/";	

    if (conf == NULL)
	return;

    QString SchemeGroup;
    SchemeGroup.sprintf("Scheme %d", Scheme);

    KConfigGroupSaver *group = new KConfigGroupSaver(conf, SchemeGroup);

    QString s;
    s = conf->readEntry("Font");
    if (!s.isEmpty())
	if (s.left(1) == "/" || s.left(1) == "~")
	    fontName = s;
	else
	    fontName = KApplication::kde_datadir() + "/kpacman/fonts/" + s;	    
    bitfontFirstChar = conf->readNumEntry("FontFirstChar", 0x0e);
    bitfontLastChar = conf->readNumEntry("FontLastChar", 0x5f);
	
    s = conf->readEntry("PixmapDirectory");
    if (!s.isEmpty())
	if (s.left(1) == "/" || s.left(1) == "~")
	    pixDir = s;
	else
	    pixDir = KApplication::kde_datadir() + "/kpacman/pics/" + s;	    
    if (pixDir.right(1) != "/")
	pixDir.append("/");

    delete(group);
}

void KPacmanWidget::setScheme(KConfig *conf, int Scheme)
{
    delete bitfont;

    getScheme(conf, Scheme);

    bitfont = new Bitfont(fontName, bitfontFirstChar, bitfontLastChar);
    if (bitfont->width() == 0 || bitfont->height() == 0) {
 	QString msg = i18n("The bitfont could not be contructed.\n\n"
			   "The file '@FONTNAME@' does not exist,\n"
			   "or is of an unknown format.");
	msg.replace(QRegExp("@FONTNAME@"), fontName);
	QMessageBox::information(this, i18n("Initialization Error"),
			 	 (const char *) msg);
    }

    score->setFont(bitfont);
    referee->setFont(bitfont);
    referee->setPixmaps(pixDir);
    status->setPixmaps(pixDir);

    setFixedSize(referee->width(),
	         bitfont->height()*3 + referee->height() + status->height());

    score->repaint(FALSE);
    referee->repaint(FALSE);
    status->repaint(FALSE);
}

void KPacmanWidget::resizeEvent( QResizeEvent * )
{
    referee->setGeometry(0, bitfont->height()*3, referee->width(), referee->height());
    referee->setBackgroundColor(BLACK);

    status->setGeometry(0, bitfont->height()*3+referee->height(), referee->width(),
		        status->height());
    status->setBackgroundColor(BLACK);

    score->setGeometry(0, 0, referee->width(), bitfont->height()*3+referee->height()+status->height());
    score->setBackgroundColor(BLACK);
}

