#ifndef KPACMAN_H
#define KPACMAN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <klocale.h>
#include <ktopwidget.h>
#include <qregexp.h>

#include "kpacmanwidget.h"

#include <kmenubar.h>
#include <qpopmenu.h>

#include <qlist.h>
#include <qfileinf.h>

#include <referee.h>
#include <status.h>
#include <score.h>
#include <keys.h>

class KPacman : public KTopLevelWidget
{
    Q_OBJECT
public:
    KPacman(QWidget *parent = 0, const char *name = 0);
    virtual ~KPacman();

public slots:
    void forcedHallOfFame(bool);

private slots:
    void newKPacman();
    void pauseKPacman();
    void toggleHallOfFame();
    void toggleNew();
    void togglePaused();
    void quitKPacman();

    void schemeChecked(int);
    void confKeys();

private:
    KConfig *conf;
    KPacmanWidget *view;

    void menu();

    int lookupSchemes();

    KMenuBar *menuBar;
    QPopupMenu *game;
    QPopupMenu *options;
    QPopupMenu *schemes;

    int newID;
    int pauseID;
    int hofID;
    QArray<int> schemeID;
};

#endif // KPACMAN_H
