/***************************************************************************
                          dlgprofilelog.cpp
                      -------------------
    description          :
    begin                : Fri Mar 10 2000
    copyright            : (C) 2000 by Stephan Uhlmann
    email                : suhlmann@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgprofilelog.h"

DlgProfileLog::DlgProfileLog(QWidget *parent, const char *name) : QDialog(parent,name,true){

	setCaption(i18n("Logging"));

	initDialog();

	setLoggingEnabled(false);
	setLogANSIEnabled(false);
	setLogFilename("");

	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );

	connect( logFilenameSelect_Button, SIGNAL(clicked()), SLOT(logFilenameSelectPressed()) );

}

DlgProfileLog::~DlgProfileLog(){
}

void DlgProfileLog::slotOKPressed()
{
	if ( (getLoggingEnabled()) && (getLogFilename()=="") )
	{
		// user enabled logging but didn't entered a filename for teh log
		QMessageBox LoggingButNoLogfile("Kmud",i18n("You enabled logging but selected no logfile."),QMessageBox::Information,
		QMessageBox::Ok | QMessageBox::Default,0,0,0,"LoggingButNoLogfileMessageBox",TRUE,0);
		LoggingButNoLogfile.exec();			
		
	}
	else accept();
}


void DlgProfileLog::setLoggingEnabled(bool b)
{
	enableLogging_CheckBox->setChecked(b);
}

bool DlgProfileLog::getLoggingEnabled()
{
	return enableLogging_CheckBox->isChecked();
}

void DlgProfileLog::setLogANSIEnabled(bool b)
{
	enableLogANSI_CheckBox->setChecked(b);
}

bool DlgProfileLog::getLogANSIEnabled()
{
	return enableLogANSI_CheckBox->isChecked();
}


void DlgProfileLog::setLogFilename(QString fn)
{
	logFilename_LineEdit->setText(fn);
}

QString DlgProfileLog::getLogFilename()
{
	return logFilename_LineEdit->text();
}

void DlgProfileLog::logFilenameSelectPressed()
{
	KFileDialog filedialog("","*.log");

	setLogFilename(filedialog.getOpenFileName());
}

