/***************************************************************************
                          dlgmaproomproperties.cpp
                      -------------------
    description          : Room Properties Dialog Class
    begin                : Fri Apr 28 2000
    copyright            : (C) 2000 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>

#include "dlgmaproomproperties.h"

DlgMapRoomProperties::DlgMapRoomProperties(QWidget *parent, const char *name)
 : QTabDialog(parent,name, true)
{
	setCaption(i18n("Room Properties"));

	descriptionTab = new DlgMapRoomDescription(this,"Description");
	apperanceTab = new DlgMapRoomApperance(this,"Apperance");
	exitsTab = new DlgMapRoomExits(this,"Exits");
	
	setOkButton(i18n("OK"));
	setCancelButton(i18n("Cancel"));

	addTab(descriptionTab,i18n("&Description"));
	addTab(apperanceTab,i18n("&Apperance"));
	addTab(exitsTab,i18n("&Exits"));

	connect(this, SIGNAL(applyButtonPressed()), SLOT(accept()));	

	this->setFixedSize(430,300);

}

DlgMapRoomProperties::~DlgMapRoomProperties()
{
}

void DlgMapRoomProperties::addExit(QString exit)
{ exitsTab->addExit(exit); }

int DlgMapRoomProperties::getNumExits(void)
{ return exitsTab->getNumExits(); }

QString DlgMapRoomProperties::getExit(int index)
{ return exitsTab->getExit(index); }

QString DlgMapRoomProperties::getLabel(void)
{ return descriptionTab->getLabel(); }

void DlgMapRoomProperties::setLabel(QString label)
{ descriptionTab->setLabel(label); }

QString DlgMapRoomProperties::getDescription(void)
{ return descriptionTab->getDescription(); }

void DlgMapRoomProperties::setDescription(QString description)
{ descriptionTab->setDescription(description); }

void DlgMapRoomProperties::setColour(QColor col)
{ apperanceTab->setColour(col); }

QColor DlgMapRoomProperties::getColour(void)
{ return apperanceTab->getColour(); }

void DlgMapRoomProperties::setUseDefaultCol(bool b)
{ apperanceTab->setUseDefaultCol(b); }

bool DlgMapRoomProperties::getUseDefaultCol(void)
{ return apperanceTab->getUseDefaultCol(); }
