/***************************************************************************
                          cmudstream.cpp
                      -------------------
    description          : Class for wrapping telnet I/O
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by Stephan Uhlmann,
                                       Andre Alexander Bell
    email                : suhlmann@gmx.de
                           andre.bell@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kprocess.h>

#include "kmud.h"
#include "cmudstream.h"
#include "kmudplugin.h"
#include "cpluginmanager.h"
#include <iostream.h>

CMudStream::CMudStream(KmudApp* app)
{
	kmudapp=app;
	view=app->getView();
	doc=app->getDoc();
	connection=app->getConnection();
	log=app->getMudLog();
	pluginmanager=app->getPluginManager();
#ifdef MAPPER
	mapper=app->getMapper();
#endif

	AutologinFinished=false;
	LoginHasBeenSent=false;
	PasswordHasBeenSent=false;
}

CMudStream::~CMudStream()
{
}

void CMudStream::setCharDBEntry(CharDBEntry *e)
{
        entry = e;
}


#ifdef MAPPER
void CMudStream::setMapper(CMapWindow *map)
{
        mapper = map;
}
#endif

void CMudStream::slotProcessOutput(QString s)
{
  TriggerEntry* trigger=NULL;
  CCharacterProfile* prof=NULL;
  QString output=s.copy();
  QString beautyfiedoutput=s.copy();
	QString output2;
	PluginList pluginlist;
	PluginInfo* plugininfo;


  prof = doc->getCharacterProfile (doc->getCurrentCharacterID ());

  /* here goes your alias/trigger/whatever filter-function call */
  /* take "output" and return the result of your filter to "output" again */


	// plugins, raw output
	pluginlist=pluginmanager->getRunningPlugins();
	plugininfo=pluginlist.first();
	while (plugininfo!=NULL)
	{
		if (plugininfo->pointer!=NULL)
			output2 = plugininfo->pointer->processRawOutput(output);
		output=output2;
		plugininfo=pluginlist.next();
	}


	// mud view
  if (view)
  {
    beautyfiedoutput = view->displayMudOutput(output);
  }


	// plugins, parsed output
	pluginlist=pluginmanager->getRunningPlugins();
	plugininfo=pluginlist.first();
	output=beautyfiedoutput;
	while (plugininfo!=NULL)
	{
		if (plugininfo->pointer!=NULL)
			output2 = plugininfo->pointer->processParsedOutput(output);
		output=output2;
		plugininfo=pluginlist.next();
	}
	beautyfiedoutput=output;

  // logging
  if ((prof) && (log))
  {
		if (prof->getLogANSIEnabled()==true)
			log->append(output);
		else
			log->append(beautyfiedoutput);
  }

  if (prof)
  {
    // start trigger
    trigger = prof->firstTrigger ();
    while (trigger)
    {
      if (output.contains (trigger->name, false))
      {
        slotProcessInput (trigger->definition + "\n");
        // if (view) view->slotAppendToOutput (trigger->definition + "\n");
      }
      trigger = prof->nextTrigger ();
    }
    // end trigger

  } // if

#ifdef MAPPER
  if (mapper)
  {
       	if (entry!=NULL)
        {
		CMudProfile* mudPro = doc->getMudProfile(entry->mudfile);
		directions *dirs = mudPro->getDirections();

		if (mudPro->getDoMoveCheck())
		{			
			if(output.contains(mudPro->getCanMoveStr()))
			{
				direction *dir=directionList.pop();
				if (dir)
				{
					mapper->movePlayerBy(*dir);
					delete dir;
				}
			}
		}
		
		if (mudPro->getDoMoveCheck())
		{			
			if(output.contains(mudPro->getNoMoveStr()))
			{
				direction *dir=directionList.pop();
				if (dir)
				{				
					delete dir;
				}
			}
		}
	}
  }
#endif
		
  autologin(beautyfiedoutput);




  emit(processedOutput());

} // slotProcessOutput

void CMudStream::slotProcessInput(QString s)
{
	QString input=s.copy();
	QString output;
	CCharacterProfile* prof=NULL;
	PluginList pluginlist;
	PluginInfo* plugininfo;
	
	prof = doc->getCharacterProfile (doc->getCurrentCharacterID ());

	/* here goes your alias/trigger/whatever filter-function call */
	/* take "input" and return the result of your filter to "input" again */

	// Mapper direction tracking stuff
#ifdef MAPPER
	if (mapper)
	{
        	if (entry!=NULL)
	        {
			CMudProfile* mudPro = doc->getMudProfile(entry->mudfile);
			directions *dirs = mudPro->getDirections();

       			if (mudPro->getFollowMode())
			{
				if (mudPro->getDoMoveCheck())
				{			
					if (input.mid(0,input.length()-1) == dirs->north ) directionList.push(new direction(NORTH));
					if (input.mid(0,input.length()-1) == dirs->northeast ) directionList.push(new direction(NORTHEAST));
					if (input.mid(0,input.length()-1) == dirs->east ) directionList.push(new direction(EAST));
					if (input.mid(0,input.length()-1) == dirs->southeast ) directionList.push(new direction(SOUTHEAST));
					if (input.mid(0,input.length()-1) == dirs->south ) directionList.push(new direction(SOUTH));
					if (input.mid(0,input.length()-1) == dirs->southwest ) directionList.push(new direction(SOUTHWEST));
					if (input.mid(0,input.length()-1) == dirs->west ) directionList.push(new direction(WEST));
					if (input.mid(0,input.length()-1) == dirs->northwest ) directionList.push(new direction(NORTHWEST));
					if (input.mid(0,input.length()-1) == dirs->up ) directionList.push(new direction(UP));
					if (input.mid(0,input.length()-1) == dirs->down ) directionList.push(new direction(DOWN));
				}
				else
				{
					if (input.mid(0,input.length()-1) == dirs->north ) mapper->movePlayerBy(NORTH);
					if (input.mid(0,input.length()-1) == dirs->northeast ) mapper->movePlayerBy(NORTHEAST);
					if (input.mid(0,input.length()-1) == dirs->east ) mapper->movePlayerBy(EAST);
					if (input.mid(0,input.length()-1) == dirs->southeast ) mapper->movePlayerBy(SOUTHEAST);
					if (input.mid(0,input.length()-1) == dirs->south ) mapper->movePlayerBy(SOUTH);
					if (input.mid(0,input.length()-1) == dirs->southwest ) mapper->movePlayerBy(SOUTHWEST);
					if (input.mid(0,input.length()-1) == dirs->west ) mapper->movePlayerBy(WEST);
					if (input.mid(0,input.length()-1) == dirs->northwest ) mapper->movePlayerBy(NORTHWEST);
					if (input.mid(0,input.length()-1) == dirs->up ) mapper->movePlayerBy(UP);
					if (input.mid(0,input.length()-1) == dirs->down ) mapper->movePlayerBy(DOWN);
				
				}
				
			}
		}
	}
#endif

	// speedwalking
	QString speedwalkingChar = view->getSpeedwalkingChar ();
	uint slen=speedwalkingChar.length();
	if ((slen> 0) && ((slen+ 1) < input.length ()) && (input.left (slen) == speedwalkingChar))
		inSpdWalk(input,speedwalkingChar);

	// extern commands
	QString externChar = view->getExternChar ();
	slen = externChar.length ();
	if ((slen > 0) && ((slen + 1) < input.length ()) && (input.left (slen) == externChar))
		inExternCommand (input, externChar);

	// separator-char-recognition
	QString separatorChar = view->getSeparator ();
	if (separatorChar != "")
	{
		inSeparator (input, separatorChar);
	} // if

	// backslash recognition
	inBackslash(input);
	
	// logging
	if (connection->isConnected ())
	{
		if (log)
			if (connection->isEchoOn())
				log->append(input);
		connection->sendData(input,input.length());
	}

	// plugins
	pluginlist = pluginmanager->getRunningPlugins();
	plugininfo=pluginlist.first();
	while (plugininfo!=NULL)
	{
		if (plugininfo->pointer!=NULL)
			output = plugininfo->pointer->processInput(input);
		input=output;
		plugininfo=pluginlist.next();
	}


	view->slotAppendToOutput (input);
	emit(processedInput());
} // slotProcessInput

/** proccess speedwalking */
void CMudStream::inSpdWalk(QString & input, QString speedwalkingChar){
	int m, n;
	uint l;
	bool b;
	QString num="",com="",out="",temp=input.right(input.length()-speedwalkingChar.length()).stripWhiteSpace();
	m = 0;
	for (l = 0; l < temp.length (); l++){
		if ((temp[l] >= '0') && (temp[l] <= '9'))
		{
			if (com != "")
				for (n = 0; n < m; n++)
					out += com + "\n";					
			com = "";
			num += temp[l];
		} // if
		else
		{
			if (num != "")
			{
				m = num.toInt (&b);
				if (!b)
					m = 0;
			} // if
			num = "";
			com += temp[l];
		} // else
	}//for
	for (n = 0; n < m; n++)
		out += com + "\n";					
	input = out;
}

/** proccess backslashes */
void CMudStream::inBackslash(QString & input){
	QString temp= input.copy ();
	input = "";
	uint l;
	bool b = false;
	if (temp[0] != '\\')
		input += temp[0];
	for (l = 1; l < temp.length (); l++)
	{
		if ((temp[l - 1] == '\\') && (!b))
		{
			switch (temp[l]) {
				case 'n':
					input += '\n';
					break;
				case 'r':
					input += '\r';
					break;
				case 't':
					input += '\t';
					break;
				case 'a':
					input += '\a';
					break;
				case '\\':
					input += '\\';
					b = true;
					break;
				default:
					input += temp[l];
			}
		} // if
		else
		{
			if (temp[l] != '\\')
			{
				input += temp[l];
			} // if
			b = false;
		} // else
	} // for
}

/** splits the input into pieces, using the separator-char */
void CMudStream::inSeparator (QString & input, QString separatorChar)
{
	int spos = input.find (separatorChar);
	uint slen = separatorChar.length ();
	while (spos > -1)
	{
		input.replace (spos, slen, "\n");
		spos = input.find (separatorChar);
	} // while
} // inSeparator

/** processes call to external commands */
void CMudStream::inExternCommand (QString & input, QString externChar)
{
	KShellProcess proc;
	QString temp = input.copy ();
	temp.remove (0, externChar.length ());
	proc << temp;
	proc.start (proc.DontCare);
	input = "";
} // inExternCommand

/** reset's the autologin */
void CMudStream::reset ()
{
	AutologinFinished=false;
	LoginHasBeenSent=false;
	PasswordHasBeenSent=false;
	entry = NULL;
} // reset

void CMudStream::autologin(QString output)
{
	if (entry)
	{
		if (!AutologinFinished)
		{
			CMudProfile* selectedMud=doc->getMudProfile(entry->mudfile);
	
		  if (!LoginHasBeenSent)
		  {
				QString NamePrompt=selectedMud->getNamePrompt();
				if (NamePrompt!="")
				{
					if (output.contains(NamePrompt,false))
					{
						slotProcessInput(entry->login+"\n" );
			  		LoginHasBeenSent=true;
					}
				}
				else
				{
				  LoginHasBeenSent=true;
				}
			}
		  	
			if (!PasswordHasBeenSent)
			{
				if (entry->password!="")
				{
					QString PasswordPrompt=selectedMud->getPasswordPrompt();
					if (PasswordPrompt!="")
					{
						if (output.contains(PasswordPrompt,false))
						{
							slotProcessInput(entry->password+"\n" );
							PasswordHasBeenSent=true;
						}
					}
					else
					{
					  PasswordHasBeenSent=true;
					}
				}
				else
				{
				  PasswordHasBeenSent=true;
				}
			}
			
			if (LoginHasBeenSent && PasswordHasBeenSent)
			{
			  AutologinFinished=true;
			}
		}		
	}
}