/***************************************************************************
                          cmapper.h
                      -------------------
    description          : Auto Mapper Window Class
    begin                : Tue Oct 19 1999
    copyright            : (C) 1999 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPWINDOW_H
#define CMAPWINDOW_H

#include <ktmainwindow.h>
#include <kaccel.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kmenubar.h>
#include <klocale.h>

#include "cmapwidget.h"
#include "kmuddoc.h"
#include "dialogs/dlgmapoptionspreferences.h"
#include "dialogs/dlgmapinfo.h"
#include "resource.h"

/**The map view widget witch is used to resize the map better
  *@author John-Paul Stanford
  */
class CMapView : public QScrollView
{
	 Q_OBJECT
public:
	CMapView::CMapView(QWidget *parent, const char *name) : QScrollView(parent,name) { }

	/** Used to add a map to the map view */
    void addMap(CMapWidget *mapWidget);
	
protected:
	/** the resize event which has been over riddent to risze the map correctly */
	void resizeEvent(QResizeEvent *e);	

private:
	CMapWidget *map;
};


/**The Auto Mapper Window Class
  *@author John-Paul Stanford
  */
class CMapWindow : public KTMainWindow
{
	Q_OBJECT
public:
	/** Constructor */
	CMapWindow(QString mudTitle,QString mudLogin,KmudDoc *document);
	/** Destructor */
	~CMapWindow();

	/** Setup the menu bar */
	void initMenubar(void);
	/** Used to setup the toolbars */
	void initToolBars(void);
	/** Setup the status bar */
	void initStatusBar(void);
	/** Used to read the mappers options */
	void readOptions(void);
	/** Used to save the mappers options */
	void saveOptions(void);

	/** Move the player */
	void movePlayerBy(direction dir);

signals:
	void slotMapperClosed();
	void movePlayer(direction);

private:
	// The colour values for the map
	QColor backgroundColour;	
	QColor gridColour;
	QColor lowerRoomColour;
	QColor defaultRoomColour;
	QColor higherRoomColour;
	QColor lowerPathColour;
	QColor defaultPathColour;
	QColor higherPathColour;
	QColor loginColour;
	QColor selectedColour;
	QColor defaultTextColour;
	
	
	/** Used to specify if the speed walking should be
	  * limited to a certian amount of moves */
	bool bLimitSpeedWalk;
	/** The number of moves before speed walking aborts */
	int speedWalkLimit;
	/** Used to specify the default path type */
	bool bTwoWay;
	/** The tools toolbar position */
	KToolBar::BarPosition tools_toolbar_pos;
	/** The modes toolbar position */
	KToolBar::BarPosition modes_toolbar_pos;
	/** The main toolbar position */
	KToolBar::BarPosition main_toolbar_pos;
	/** The mapper windows width */
	int mapperWindowWidth;
	/** The mapper windows height */
	int mapperWindowHeight;
	/** flag if statusbar is visible or not. */
	bool bViewStatusbar;
	/** flag if the tools toolbar is visible or not */
	bool bViewToolsToolbar;
	/** flag if the modes toolbar is visible or not */
	bool bViewModesToolbar;
	/** flag if the modes toolbar is visible or not */
	bool bViewMainToolbar;
	/** flag if the lower map is visible */
	bool bViewLowerMap;
	/** flag ig the upper map is visible */
	bool bViewHigherMap;
	/** flag if the overview is visible */
	bool bViewOverview;
	/** flag if the grid is visiable */
	bool bGridShow;
	/** The file menu */
	QPopupMenu *file_menu;
	/** The edit menu */
	QPopupMenu *edit_menu;
	/** The options menu */
	QPopupMenu *options_menu;
	/** The options menu */
	QPopupMenu *view_menu;
	/** The tools menu */
	QPopupMenu *tools_menu;
	/** The scroll view widget used to display the map */
	CMapWidget *map;
	/** The scroll view used to display the map */
	//QScrollView *mapView;
	CMapView *mapView;
	/** Holds kmud settings */
	KmudDoc *doc;
	/** Mud Title */
	QString mud_Title;
	/** Character name */
	QString mud_Login;
	/** The tools toolbar */
	KToolBar *toolsToolbar;
	/** The modes toolbar */
	KToolBar *modesToolbar;
	/** The modes toolbar */
	KToolBar *mainToolbar;

protected:
	void closeEvent(QCloseEvent *e);

public slots:
	/** Used to turn the overview on or off */
	void slotViewOverview(void);
	/** switch argument for slot selection by menu or toolbar ID */
	void commandCallback(int id_);
	/** switch argument for Statusbar help entries on slot selection */
	void statusCallback(int id_);
	/** close the map window */
	void slotFileCloseWindow(void);
	/** export the map to a different format */
	void slotFileExport(void);
	/** import the map to a different format */
	void slotFileImport(void);
	/** this slot is called when the user selects the erase map menu options */
	void slotFileNew(void);
	/** This slot is used to display information about the map */
	void slotFileInfo(void);
	/** view the preferences for the mapper */
	void slotOptionsPrefs(void);
	/** change the status message to text */
	void slotStatusMsg(const char *text);
	/** change the status message of the whole statusbar temporary */
	void slotStatusHelpMsg(const char *text);
	/** turn on or off the status bar */
	void slotViewStatusBar(void);
	/** turn on or off the tools toolbar */
	void slotViewTools(void);
	/** turn on or off the main toolbar */
	void slotViewMainToolBar(void);	
	/** turn on or off the modes toolbar */
	void slotViewModesToolBar(void);
	/** turn on or off follow mode */
	void slotOptionsFollow(void);
	/** turn on or off create mode */
	void slotOptionsCreate(void);
	/** This slot is called when the copy menu option is selected */
	void slotEditCopy(void);
	/** This slot is called when the paste menu option is selected */
	void slotEditPaste(void);
	/** This slot is called when the cut menu option is selected */
	void slotEditCut(void);
	/** This slot is called when the delete menu option is selected */
	void slotEditDelete(void);
	/** This slot is used to select all elements */
	void slotSelectAll(void);
	/** This slot is used to deselect all elements */
	void slotDeselectAll(void);
	/** This slot is used to invert the elements selected */
	void slotInvertSelection(void);
	/** This slot is used to activate the select tool */
	void slotToolSelect(void);
	/** This slot is used to activate the create room tool */
	void slotToolCreateRoom(void);
	/** This slot is used to activate the create path tool */
	void slotToolCreatePath(void);
	/** This slot is used to activate the create text tool */
	void slotToolCreateText(void);
	/** This slot is used to activate the erase tool */
	void slotToolErase(void);
	/** This slot is used to create a new top level */
	void slotCreateTopLevel(void);
	/** This slot is used to create a new bottom level */
	void slotCreateBottomLevel(void);	
	/** This slot is used to show/hide the grid */	
	void slotShowGrid(void);
	/** Turn on or off the higher map */
	void slotViewHigherMap(void);
	/** Turn on or off the lower map */
	void slotViewLowerMap(void);
	/** Slot used to move the player */
	void slotMovePlayer(direction dir);
	/** Slot used to update the staus bar with the new level num */
 	void slotLevelChanged(signed int level);
	void slotLevelUp(void);
	void slotLevelDown(void);
};


#endif
