/**********************************************************************

	--- Qt Architect generated file ---

	File: prefaudio.cpp
	Last generated: Tue Jul 14 13:17:55 1998

 *********************************************************************/

#include "prefaudio.h"
#include <kapp.h>
#include <ksimpleconfig.h>

#define Inherited PrefAudioData

PrefAudio::PrefAudio(QWidget* parent, const char* name)
	:Inherited( parent, name )
{
}


PrefAudio::~PrefAudio()
{
}


void PrefAudio::setPrefs(struct audio_prefs *prefs)
{
    checkSound->setChecked(prefs->play_sound);
    checkFakeSound->setChecked(prefs->fake_sound);
    comboDevice->setCurrentItem(prefs->audiodevice);
}


void PrefAudio::writeConfig(struct audio_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Audio";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (prefs->play_sound != checkSound->isChecked())
        config.writeEntry("play_sound",checkSound->isChecked());
    else
        config.deleteEntry("play_sound", false);
    if (prefs->fake_sound != checkFakeSound->isChecked())
        config.writeEntry("fake_sound",checkFakeSound->isChecked());
    else
        config.deleteEntry("fake_sound", false);
    if (prefs->audiodevice != comboDevice->currentItem())
        config.writeEntry("audiodevice",comboDevice->currentItem());
    else
        config.deleteEntry("audiodevice", false);
}


void PrefAudio::readConfig(struct audio_prefs *prefs, const char *cname)
{
    QString
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Audio";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("play_sound"))
        prefs->play_sound = config.readNumEntry("play_sound");
    if (config.hasKey("fake_sound"))
        prefs->fake_sound = config.readNumEntry("fake_sound");
    if (config.hasKey("audiodevice"))
        prefs->audiodevice = config.readNumEntry("audiodevice");
}


const QString PrefAudio::optionString(struct audio_prefs *prefs, const char *cname)
{
    QString
        opt = "",
        cgroup = cname,
        aConfigName = KApplication::localconfigdir() + "/kmamerunrc";

    cgroup += "Audio";
    KSimpleConfig config(aConfigName);
    config.setGroup(cgroup);
    if (config.hasKey("play_sound")) {
        if (prefs->play_sound)
            opt += "-sound";
        else
            opt += "-nosound";
    }
    if (config.hasKey("fake_sound")) {
        if (prefs->fake_sound)
            opt += "-fakesound";
    }
    if (config.hasKey("audiodevice")) {
        if (prefs->audiodevice == 0)
            opt += "-usedsp";
        else
            opt += "-useaudio";
    }
    return opt;
}
