#ifndef KGREDITFIELD_H
#define KGREDITFIELD_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <qevent.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <kiconloader.h>

const char FREE = ' ';
const char ENEMY = 'E';
const char HERO = 'R';
const char BETON = 'X';
const char BRICK = 'M';
const char FBRICK = 'F';
const char HLADDER = 'Z';
const char LADDER = 'H';
const char NUGGET = 'N';
const char POLE = 'T';


const int fieldw = 16;
const int fieldh = 16;

class kgreditField : public QWidget
{
  Q_OBJECT
 public:
  kgreditField(int id, int x, int y, QWidget * parent=0, 
	       const char * name=0);
  virtual ~kgreditField();  
  void mousePressEvent(QMouseEvent * ev);
  void mouseReleaseEvent(QMouseEvent * ev);
  void enterEvent(QEvent * ev);
  void leaveEvent(QEvent * ev);
  void setMousePressStatus(bool set);
  void setActivePixmap(QPixmap &pix); // Aktive meint das Ausgewhlte Objekt
  void setActiveObject(unsigned char obj); // beim Ersttellen des Levels
  void clean();
  void setObject(unsigned char obj); // diese beiden Methoden
  void setPixmap(QPixmap &pix); // setzten den Zustand beim Laden des Levels
  unsigned char getObject();

public slots:

 signals:
 void setPressedStatus(bool p); // Sendet den MousePressEventWechsel 
 void getPressedStatus(int field); // Anfrage nach oben dem MausStatus
 void getActivePix(int field); // Anfrage nach oben nach der Pixmap vom aktuellen Objekt
 void getActiveObject(int field); // Anfrage nach oebn nach dem aktuellen Objekt
 
 private:
  int myid; // ID dieses Widgets
  int x_pos,y_pos; // Position relativ zum ParentWidget
  unsigned char object_id; // das diesem Widget zugewiesene Objekt
  unsigned char object_tmp; // das von oben gelieferte aktive Objekt
  QPixmap fixpix; // gesetzte Pixmap
  QPixmap tmppix; // Pixmap, wenn der Curser drbersteht.
  QPixmap bgpix; // Pixmap, des Hintergrunds
  bool mouse_pressed; // der von oben gelieferte Mausstatus
  
  
};
#endif // KGREDITFIELD_H
