/* view_player.cpp
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#include <qobject.h>
#include <qwidget.h>
#include <qsignal.h>
#include "go_board.h"
#include "go_player.h"
#include "vp_player.h"
#include "view_player.moc"

KViewPlayer::KViewPlayer( int c, KGoBoard *b, QWidget *parent,
		const char *name )
 	: KGoView( b, parent, name )
{
	dummy = new KVP_Player( this, c, b, 0, name ) ;
	inf = new QLabel("", this, "inf" ) ; 
	passb = new QPushButton( "Pass", this, "pass" ) ;

	connect( passb, SIGNAL( clicked()),
			this, SLOT(pass()) ) ;
	connect( this, SIGNAL( positionLeftClicked(int, int)),
			dummy, SLOT( playMove(int,int)) ) ;
	connect( dummy, SIGNAL( notifyIllegalMove(int,int)),
		this, SLOT( receiveIllegalMove(int,int)) ) ;

}

KViewPlayer::~KViewPlayer()
{
	// note: we don't delete dummy
	// this should be done in the kgo_widget
	delete passb ;
}

void KViewPlayer::setInformation( const char *s )
{
	inf->setText( s ) ;
}

void KViewPlayer::pass()
{
	dummy->playMove( PASS, PASS ) ;
}

KGoPlayer* KViewPlayer::getPlayer()
{
	return dummy ;
}

void KViewPlayer::receiveIllegalMove( int r, int p )
{
	if ( p == dummy->getColor() )
	{
		QString tmp ;
		tmp.sprintf( "%s %s", 
			klocale->translate("You made an illegal move:" ),
			KGoBoard::getIllegalMoveReason( r ).data()
				) ; 
		info( tmp.data() ) ;
	}
}

void KViewPlayer::resizeEvent( QResizeEvent * )
{
	QSize s = size() ;

	inf->setGeometry( 10, 10, s.width()-70, 20 ) ;
	passb->setGeometry( s.width()-60, 10, 50, 20 ) ;

	QRect r = QRect( 0, 50, s.width(), s.height() - 50 ) ;

	this->KGoView::resizeEvent( r ) ;
}

