/* netdialog.h
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#ifndef NETDIALOG_H
#define NETDIALOG_H

#include <includes.h>
#include <ksock.h>

#include "knetobject.h"

#define DEFAULT_PORT 5001
#define DEFAULT_HOST "localhost"

/* current state */
#define CHOOSE_MODE 1
#define SERVER 2
#define CLIENT 3
#define SERVER_CONNECTED 4
#define SERVER_LISTENING 5
#define CLIENT_CONNECTED 6

/**
 * This dialog created a network connection. It returns
 * a NetObject which  can be used to read and write data.
 */
class NetDialog : public QDialog
{
	Q_OBJECT
public:	
	NetDialog( QWidget *parent ) ;
	~NetDialog() ;

	KNetObject* getNetObject() ;
	/**
	 * Check if this NetDialog was used as a server or a client
	 *
	 * @return true if this was a server
	 */
	bool isServer() ;

protected slots:
	void show_mode() ;
	void choose_mode() ;

	void show_serverclient( int ) ;

	void server_clicked() ;
	void client_clicked() ;

	void server_start() ;
	void server_end() ;
	void client_start() ;
	void client_end() ;

	void ok_clicked() ;
	void reject() ; 	

	void acceptSocket( KSocket * ) ;

protected:
	int current_state ;

	QPushButton *server_button, *client_button ;

	QLabel *info ;
	QLabel *address_label ;
	QLineEdit *address ;
	QLabel *port_label ;
	KIntegerLine *port ;

	QPushButton *ok, *cancel ;

	KServerSocket *server ;
	KSocket *client ;
	KNetObject *netobject ;
} ;

#endif

