/* go_view.cpp
 *
 * Pieter Eendebak <pte@ddsw.nl>
 */

#include "includes.h"
#include "go_view.moc"
#include "go_board.h"
#include "KMoveList.h"

KGoView::KGoView( KGoBoard *b=0, QWidget *parent, const char *name )
	: QWidget ( parent, name, 0 )
{
	bview = new KGoBoardView( b, parent, name ) ;
	info_label = new QLabel( "", this, "info" ) ;

	connect( bview, SIGNAL( positionClicked( int, int, int )),
			this, SLOT( position_clicked( int, int, int)) ) ; 

	setBoard( b ) ;
	setMinimumSize( 50, 50 ) ;
	resizeEvent( 0 ) ; 
}

KGoView::~KGoView()
{
	delete bview ;
	delete info_label ;

}

void KGoView::position_clicked(int x,int y,int b)
{
	emit positionClicked( x, y, b ) ;

	if ( b==LeftButton )
		emit positionLeftClicked( x, y ) ; 
}

void KGoView::resizeEvent( QResizeEvent * )
{
	resizeEvent( rect() ) ;
}

void KGoView::resizeEvent( QRect r )
{
	int x_offset = r.x() ;
	int y_offset = r.y() ;
	int w = r.width() ;
	int h = r.height() ;
	const int border = 5 ;

	info_label->setGeometry( x_offset+2*border, y_offset+border,
				w - 2*border, 20 ) ;
 	bview->setGeometry( x_offset+border, y_offset+30+border,
			w-20, h-30-2*border ) ;
}

void KGoView::receiveMove( int x, int y, int p)
{
	QString tr = KGoBoard::translateMove( x, y ) ;

	lastMove( x, y, p ) ;

	QString tmp ;
	if ( p==WHITE )
		tmp = klocale->translate("White moved: ") ;
	else	tmp = klocale->translate("Black moved: ") ;

	tmp.append( tr ) ;
	info ( tmp.data() ) ;
}

void KGoView::info( const char *s )
{
	info_label->setText( s ) ;
}


void KGoView::lastMove( int x, int y, int p )
{
	bview->lastMove( x, y, p ) ;
} 

void KGoView::setBoard( KGoBoard *b )
{
	if ( b != 0 )
		board = b ;
	else b = new KGoBoard() ;
	redraw() ;
}

void KGoView::boardStateChange(int r)
{
	switch( r )
	{
		case PLAYING:	break ;
		default:	redraw();
				break ;
	}
}

void KGoView::redraw()
{
	bview->redraw() ;
}

void KGoView::setStyle( int s )
{
	style = s ;
}

void KGoView::legenda( bool b )
{
	bview->legenda( b ) ;
}

bool KGoView::legenda()
{
	if ( bview != 0 )
		return bview->legenda() ;
	else return false ;
}


