/***************************************************************************
                          kfun21.h  -  description                              
                             -------------------                                         

    version              : 0.1                                  
    begin                : Son Jan 24 23:06:19 CET 1999
                                           
    copyright            : (C) 1999 by Henning Busacker                         
    email                : henning.busacker@duesseldorf.netsurf.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KFUN21_H 
#define KFUN21_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <qstrlist.h>

// application specific includes
#include "kfun21view.h"
#include "fun21.h"
#include "tower.h"
/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class KMyappView is
  * created which creates your view.
  */
class Kfun21App : public KTMainWindow 
{    Q_OBJECT 
public: 
  /** construtor */
  Kfun21App(); 
  /** destructor */
  ~Kfun21App();

 public slots:
  /** enable menuentries/toolbar items */
   void enableCommand(int id_);
   /** disable menuentries/toolbar items */
   void disableCommand(int id_);
   /** switch argument for slot selection by menu or toolbar ID */
   void commandCallback(int id_);

protected:

  /** init() sets the Application title, reads the config file entries
    * by calling readOptions() and calls the initXX functions to set up
    * the main view items
    */
  void init();  
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar(); 
  /** setup the mainview*/
  void initView();
  /** resizeEvent for the main view */
  virtual void resizeEvent(QResizeEvent *evt);
  /** overloaded for Message box on last window exit */
  bool queryExit();
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions();
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();

  protected slots:      
    /** generate a new document in the actual view */
    void slotFileNew(); 
    /** open a document */
    void slotFileHighscore();
    /** exits the application */
    void slotAppExit();
    /** Toggles the Animate Flag */
    void slotOptionsAnimate();
    /** handler for the Speed Menu */
    void slotOptionsSpeedMenu(int);
    /** handler for the Game Menu */
    void slotOptionsGameMenu(int);
    
private: 
    /** menu_bar is the applications main menubar */
    KMenuBar	*menu_bar;
    QPopupMenu	*game_menu;
    QPopupMenu	*speed_menu;
    QPopupMenu	*options_menu;
    QStrList	*levelnames;
    /** view is the main widget which represents your working area. The View
      * class should handle all events of the view widget.  It is kept empty so
      * you can create your view according to your application's needs by
      * changing the view class. */
    Kfun21View	*view;
    /** rMainGeom keeps the acutal size of your application and is used to
      * restore your last used application size. */
    QRect	rMainGeom;
    /** flag if toolbar is visible or not. Used for kconfig and checking the
      * view-menu entry view toolbar. bViewStatusbar does the same for the
      * statusbar. 
      */
    bool	bViewEnabled;
    /** flag if animation should be shown on startup or not Used for kconfig */
    bool	bAnimate;
    /** which game to play. Used for kconfig */
    int		iGameID;
    /** selected Speed for the game */
    int		iSpeed;
    /** used for KConfig to store and restore menubar position. Same with
      * tool_bar_0_pos. If more menubars or toolbars are created, you should add
      * positions as well and implement them in saveOptions() and readOptions().
      */    
    KMenuBar::menuPosition menu_bar_pos;
};   
 
#endif // KFUN21_H
 
 
 
 
 
 
 
 




